/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.e6tech.elements.common.logging.ConsoleLogger;
import net.e6tech.elements.common.logging.LogHandler;
import net.e6tech.elements.common.logging.LoggerExtension;
import net.e6tech.elements.common.logging.NullLogger;
import net.e6tech.elements.common.reflection.Reflection;
import org.apache.logging.log4j.ThreadContext;

public interface Logger
extends org.slf4j.Logger,
LoggerExtension {
    public static final String logDir = "elements.common.logging.logDir";

    public static void suppress(Throwable th) {
    }

    public static void put(String name, String value) {
        ThreadContext.put((String)name, (String)value);
    }

    public static String get(String name) {
        return ThreadContext.get((String)name);
    }

    public static Logger getLogger() {
        Class cls = Reflection.getCallingClass();
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(cls));
    }

    public static Logger getLogger(Class cls) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(cls));
    }

    public static Logger getLogger(String name) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(name));
    }

    public static Logger nullLogger() {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(new NullLogger()));
    }

    public static Logger consoleLogger() {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(new ConsoleLogger()));
    }

    public static Logger from(org.slf4j.Logger logger) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LogHandler(logger));
    }
}

