/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.DefaultPluginModel;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginEntry;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.util.SystemException;

public interface PluginModel {
    public Resources getResources();

    public String getName();

    default public <P extends Plugin> PluginEntry<P> registerPlugin(PluginPath<P> path, P plugin) {
        PluginManager pluginManager = this.getResources().getPluginManager();
        PluginEntry<P> entry = pluginManager.add(path, plugin);
        pluginManager.lookup(entry.getPath()).ifPresent(p -> p.onRegistered(this));
        return entry;
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(PluginPath<P> path, Class<? extends P> pluginClass) {
        PluginManager pluginManager = this.getResources().getPluginManager();
        PluginEntry<Class<P>> entry = pluginManager.add(path, pluginClass);
        pluginManager.lookup(entry.getPath()).ifPresent(p -> p.onRegistered(this));
        return entry;
    }

    default public <P extends Plugin> Object unregisterPlugin(PluginPath<P> path) {
        PluginManager pluginManager = this.getResources().getPluginManager();
        Object entry = pluginManager.remove(path);
        pluginManager.lookup(path).ifPresent(p -> p.onUnregistered(this));
        return entry;
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class<P> pluginBaseClass, P plugin) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> Object unregisterPlugin(Class<P> pluginBaseClass) {
        return this.unregisterPlugin(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass));
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass, P plugin) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> Object unregisterPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass) {
        return this.unregisterPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass));
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> pluginBaseClass, P plugin) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> Object unregisterPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> pluginBaseClass) {
        return this.unregisterPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pluginBaseClass));
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> pluginBaseClass, P plugin) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pathClass3, pathAttribute3).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> PluginEntry<P> registerPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        return this.registerPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pathClass3, pathAttribute3).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> Object unregisterPlugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> pluginBaseClass) {
        return this.unregisterPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pathClass3, pathAttribute3).and(pluginBaseClass));
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class pathClass, String pathAttribute, Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pathClass3, pathAttribute3).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class<P> cls) {
        return PluginPaths.of(this.getClass(), this.getName(), cls);
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class pathClass, String pathAttribute, Class<P> cls) {
        return PluginPaths.of(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(cls));
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> cls) {
        return PluginPaths.of(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(cls));
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> cls) {
        return PluginPaths.of(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pathClass2, pathAttribute2).and(pathClass3, pathAttribute3).and(cls));
    }

    default public <P extends Plugin> Optional<P> getPlugin(PluginPath<P> path, Object ... args) {
        Optional<P> optional = this.getResources().getPlugin(path, args);
        if (optional.isPresent()) {
            return optional;
        }
        if (path.parent() == null) {
            return DefaultPluginModel.from(this.getResources()).getPlugin(path.getType(), args);
        }
        return optional;
    }

    default public <P extends Plugin> Optional<PluginEntry<P>> getPluginEntry(PluginPath<P> path) {
        return this.getResources().getPluginManager().getEntry(path);
    }

    default public <P extends Plugin> Optional<P> getPlugin(Class<P> cls, Object ... args) {
        Optional<P> optional = this.getResources().getPlugin(this.getPluginPaths(cls), args);
        if (optional.isPresent()) {
            return optional;
        }
        return DefaultPluginModel.from(this.getResources()).getPlugin(cls, args);
    }

    default public <P extends Plugin> Optional<PluginEntry<P>> getPluginEntry(Class<P> cls) {
        return this.getResources().getPluginManager().getEntry(this.getPluginPaths(cls));
    }

    default public <P extends Plugin> Optional<P> getLevel2Plugin(Class pathClass, String pathAttribute, Class<P> cls, Object ... args) {
        return this.getResources().getPlugin(this.getPluginPaths(pathClass, pathAttribute, cls), args);
    }

    default public <P extends Plugin> Optional<PluginEntry<P>> getLevel2PluginEntry(Class pathClass, String pathAttribute, Class<P> cls) {
        return this.getResources().getPluginManager().getEntry(this.getPluginPaths(pathClass, pathAttribute, cls));
    }

    default public <P extends Plugin> Optional<P> getLevel3Plugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> cls, Object ... args) {
        return this.getResources().getPlugin(this.getPluginPaths(pathClass, pathAttribute, pathClass2, pathAttribute2, cls), args);
    }

    default public <P extends Plugin> Optional<PluginEntry<P>> getLevel3PluginEntry(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class<P> cls) {
        return this.getResources().getPluginManager().getEntry(this.getPluginPaths(pathClass, pathAttribute, pathClass2, pathAttribute2, cls));
    }

    default public <P extends Plugin> Optional<P> getLevel4Plugin(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> cls, Object ... args) {
        return this.getResources().getPlugin(this.getPluginPaths(pathClass, pathAttribute, pathClass2, pathAttribute2, pathClass3, pathAttribute3, cls), args);
    }

    default public <P extends Plugin> Optional<PluginEntry<P>> getLevel4PluginEntry(Class pathClass, String pathAttribute, Class pathClass2, String pathAttribute2, Class pathClass3, String pathAttribute3, Class<P> cls) {
        return this.getResources().getPluginManager().getEntry(this.getPluginPaths(pathClass, pathAttribute, pathClass2, pathAttribute2, pathClass3, pathAttribute3, cls));
    }

    default public <P extends Plugin> P newPlugin(Class<P> cls, Object ... args) {
        try {
            return (P)((Plugin)this.getPlugin(cls, args).orElse(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SystemException(e);
        }
    }

    default public <P extends Plugin> P requirePlugin(Class<P> cls, Object ... args) {
        return (P)((Plugin)this.getPlugin(cls, args).orElseThrow(InstanceNotFoundException::new));
    }

    default public <P extends Plugin> P acceptPlugin(Class<P> cls, Consumer<P> consumer, Object ... args) {
        P plugin = this.requirePlugin(cls, args);
        consumer.accept(plugin);
        return plugin;
    }

    default public <P extends Plugin, R> R applyPlugin(Class<P> cls, Function<P, R> function, Object ... args) {
        P plugin = this.requirePlugin(cls, args);
        return function.apply(plugin);
    }

    default public <P extends Plugin> Optional<P> ifPlugin(Class<P> cls, Consumer<P> consumer, Object ... args) {
        Optional<P> optional = this.getPlugin(cls, args);
        optional.ifPresent(consumer);
        return optional;
    }

    default public <P extends Plugin, R> Optional<R> mapPlugin(Class<P> cls, Function<P, R> function, Object ... args) {
        Optional<P> optional = this.getPlugin(cls, args);
        return optional.map(function);
    }

    default public Optional<PluginModel> parent() {
        return Optional.empty();
    }
}

