/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.AutoPlugin;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginEntry;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.resources.plugin.Prototype;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.file.FileUtil;

public class PluginManager {
    private static final String DEFAULT_PLUGIN = "defaultPlugin";
    private static final Object NULL_OBJECT = new Object();
    private PluginClassLoader classLoader;
    private final ResourceManager resourceManager;
    private Resources resources;
    private Map<PluginPath<?>, PluginEntry> plugins = new HashMap();
    private Map<Class<?>, Object> defaultPlugins = new HashMap();

    public PluginManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.classLoader = new PluginClassLoader(resourceManager.getClass().getClassLoader());
    }

    public PluginManager from(Resources resources) {
        PluginManager plugin = new PluginManager(this.resourceManager);
        plugin.resources = resources;
        plugin.defaultPlugins = this.defaultPlugins;
        plugin.classLoader = this.classLoader;
        plugin.plugins = this.plugins;
        return plugin;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void loadPlugins(String[] directories) {
        for (String dir : directories) {
            String[] paths;
            try {
                paths = FileUtil.listFiles(dir, ".jar");
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            for (String p : paths) {
                String fullPath;
                try {
                    fullPath = new File(p).getCanonicalPath();
                }
                catch (IOException e) {
                    continue;
                }
                try {
                    this.classLoader.addURL(Paths.get(fullPath, new String[0]).toUri().toURL());
                }
                catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
    }

    public URLClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    protected Optional getDefaultPlugin(Class<?> type) {
        Class<?> lookup = this.defaultPlugins.get(type);
        if (lookup == NULL_OBJECT) {
            return Optional.empty();
        }
        if (lookup == null) {
            for (Class<?> t = type; t != null && !t.equals(Object.class); t = t.getSuperclass()) {
                try {
                    Field field = t.getField(DEFAULT_PLUGIN);
                    lookup = field.get(null);
                    this.defaultPlugins.put(type, lookup);
                    break;
                }
                catch (IllegalAccessException | NoSuchFieldException e1) {
                    Logger.suppress(e1);
                    continue;
                }
            }
            if (lookup == null && type != null && AutoPlugin.class.isAssignableFrom(type)) {
                try {
                    PluginEntry.validateClass(type);
                    lookup = type;
                    this.defaultPlugins.put(type, lookup);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (lookup == null) {
                this.defaultPlugins.put(type, NULL_OBJECT);
            }
        }
        return Optional.ofNullable(lookup);
    }

    public Map<PluginPath, PluginEntry> startsWith(PluginPath<?> path) {
        return this.startsWith(PluginPaths.of(path));
    }

    public Map<PluginPath, PluginEntry> startsWith(PluginPaths<?> paths) {
        LinkedHashMap<PluginPath, PluginEntry> map = new LinkedHashMap<PluginPath, PluginEntry>();
        for (PluginPath path : paths.getPaths()) {
            for (Map.Entry<PluginPath<?>, PluginEntry> entry : this.plugins.entrySet()) {
                if (!entry.getKey().startsWith(path) || map.containsKey(entry.getKey())) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public <T extends Plugin> Optional<PluginEntry<T>> getEntry(PluginPath<T> path) {
        return Optional.ofNullable(this.plugins.get(path));
    }

    public <T extends Plugin> Optional<PluginEntry<T>> getEntry(PluginPaths<T> paths) {
        PluginPath path;
        PluginEntry lookup = null;
        Iterator<PluginPath> iterator = paths.getPaths().iterator();
        while (iterator.hasNext() && (lookup = this.plugins.get(path = iterator.next())) == null) {
        }
        return Optional.ofNullable(lookup);
    }

    public <T extends Plugin> Optional<T> get(PluginPaths<T> paths, Object ... args) {
        PluginEntry lookup = this.getEntry(paths).orElse(null);
        PluginPath pluginPath = null;
        Object instance = null;
        if (lookup == null) {
            pluginPath = PluginPath.of(paths.getType(), DEFAULT_PLUGIN);
        } else {
            pluginPath = lookup.getPath();
            instance = lookup.getPlugin();
        }
        return Optional.ofNullable(this.createInstance(pluginPath, instance, args));
    }

    public <T extends Plugin> T createInstance(PluginPath<T> pluginPath, Object obj, Object ... args) {
        if (obj == null && pluginPath == null) {
            return null;
        }
        if (obj == null) {
            Optional defaultPlugin = this.getDefaultPlugin(pluginPath.getType());
            if (!defaultPlugin.isPresent()) {
                return null;
            }
            obj = defaultPlugin.get();
            pluginPath = PluginPath.of(pluginPath.getType(), DEFAULT_PLUGIN);
        }
        T plugin = obj instanceof Class ? this.createFromClass(pluginPath, (Class)obj, args) : (obj instanceof PluginFactory ? this.createFromFactory(pluginPath, (PluginFactory)obj, args) : this.createFromInstance(pluginPath, obj, args));
        return plugin;
    }

    private <T extends Plugin> T createFromClass(PluginPath<T> pluginPath, Class cls, Object ... args) {
        try {
            Plugin plugin = (Plugin)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            plugin.initialize(pluginPath);
            this.inject(plugin, args);
            return (T)plugin;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private <T extends Plugin> T createFromFactory(PluginPath<T> pluginPath, PluginFactory factory, Object ... args) {
        Object plugin = factory.create(this);
        plugin.initialize(pluginPath);
        this.inject(plugin, args);
        return plugin;
    }

    private <T extends Plugin> T createFromInstance(PluginPath<T> pluginPath, Object obj, Object ... args) {
        Plugin plugin;
        Plugin prototype = (Plugin)obj;
        if (prototype instanceof Prototype) {
            plugin = (Plugin)((Prototype)((Object)prototype)).newInstance();
            plugin.initialize(pluginPath);
            this.inject(plugin, args);
        } else if (prototype.isPrototype()) {
            try {
                plugin = (Plugin)prototype.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Reflection.copyInstance(plugin, prototype);
                plugin.initialize(pluginPath);
                this.inject(plugin, args);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        } else {
            plugin = prototype;
        }
        return (T)plugin;
    }

    public void inject(Object instance, Object ... args) {
        if (instance != null && args != null && args.length > 0) {
            ResourcePool resourcePool;
            ModuleFactory factory = this.resources != null ? this.resources.getModule().getFactory() : this.resourceManager.getModule().getFactory();
            Module module = factory.create();
            for (Object arg : args) {
                if (arg instanceof Binding) {
                    Binding binding = (Binding)arg;
                    if (binding.getName() != null) {
                        module.bindNamedInstance(binding.getBoundClass(), binding.getName(), binding.get());
                        continue;
                    }
                    module.bindInstance(binding.getBoundClass(), binding.get());
                    continue;
                }
                module.bindInstance(arg.getClass(), arg);
            }
            Injector injector = this.resources != null ? module.build(this.resources.getModule(), this.resourceManager.getModule()) : module.build(this.resourceManager.getModule());
            InjectionListener injectionListener = null;
            ResourcePool resourcePool2 = resourcePool = this.resources != null ? this.resources : this.resourceManager;
            if (instance instanceof InjectionListener) {
                injectionListener = (InjectionListener)instance;
                injectionListener.preInject(resourcePool);
            }
            injector.inject(instance, true);
            if (injectionListener != null) {
                injectionListener.injected(resourcePool);
            }
        } else if (instance != null && this.resources != null) {
            this.resources.inject(instance);
        }
    }

    public <T extends Plugin> Optional<T> get(PluginPath<T> path, Object ... args) {
        return this.get(PluginPaths.of(path), args);
    }

    public synchronized <T extends Plugin> PluginEntry<T> add(PluginPath<T> path, Class<T> cls) {
        PluginEntry<T> entry = new PluginEntry<T>(path, cls);
        this.plugins.put(path, entry);
        return entry;
    }

    public synchronized <T extends Plugin> PluginEntry<T> add(PluginPath<T> path, T singleton) {
        PluginEntry<T> entry = new PluginEntry<T>(path, singleton);
        this.plugins.put(path, entry);
        this.resourceManager.inject(singleton, !singleton.isPrototype());
        singleton.initialize(path);
        return entry;
    }

    public synchronized <T extends Plugin> Object remove(PluginPath<T> path) {
        PluginEntry entry = this.plugins.remove(path);
        return entry == null ? null : entry.getPlugin();
    }

    public synchronized <T extends Plugin, U extends T> void addDefault(Class<T> cls, U singleton) {
        this.defaultPlugins.put(cls, singleton);
        this.resourceManager.inject(singleton, !singleton.isPrototype());
        singleton.initialize(PluginPath.of(cls, DEFAULT_PLUGIN));
    }

    public synchronized <T extends Plugin, U extends T> void addDefault(Class<T> cls, Class<U> implClass) {
        this.defaultPlugins.put(cls, implClass);
    }

    public Object removeDefault(Class cls) {
        return this.defaultPlugins.remove(cls);
    }

    public static class PluginClassLoader
    extends URLClassLoader {
        private List<URL> pluginURLs = new ArrayList<URL>();

        public PluginClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
            this.pluginURLs.add(url);
        }

        public URL[] getPluginURLs() {
            return this.pluginURLs.toArray(new URL[0]);
        }
    }
}

