/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MethodAnnotationReflection {
    private MethodAnnotationReflection() {
    }

    public static <T extends Annotation> Optional<Method> findMethodWithAnnotation(Method provided, Class<T> annotationCls) {
        if (annotationCls == null) {
            return Optional.empty();
        }
        return MethodAnnotationReflection.findMatchingMethodInClassHierarchy(provided, m -> m.getAnnotation(annotationCls) != null);
    }

    private static Optional<Method> findMatchingMethodInClassHierarchy(Method provided, Predicate<Method> predicate) {
        if (provided == null) {
            return Optional.empty();
        }
        if (predicate.test(provided)) {
            return Optional.of(provided);
        }
        Class<?> declaring = provided.getDeclaringClass();
        HashSet checked = new HashSet();
        ArrayDeque classesToCheck = new ArrayDeque();
        classesToCheck.add(declaring.getSuperclass());
        for (int i = declaring.getInterfaces().length - 1; i >= 0; --i) {
            classesToCheck.add(declaring.getInterfaces()[i]);
        }
        while (!classesToCheck.isEmpty()) {
            Class classToCheck = (Class)classesToCheck.pop();
            if (classToCheck == null || classToCheck == Object.class || checked.contains(classToCheck)) continue;
            Optional<Method> found = MethodAnnotationReflection.getMethodForClass(provided, classToCheck).filter(predicate);
            if (found.isPresent()) {
                return found;
            }
            checked.add(classToCheck);
            checked.add(classToCheck.getSuperclass());
            for (Class<?> anInterface : classToCheck.getInterfaces()) {
                classesToCheck.add(anInterface);
            }
        }
        return Optional.empty();
    }

    private static Optional<Method> getMethodForClass(Method methodOnDifferentClass, Class targetClass) {
        try {
            return Optional.of(targetClass.getMethod(methodOnDifferentClass.getName(), methodOnDifferentClass.getParameterTypes()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            List sameNameSameParamCount = Arrays.stream(targetClass.getMethods()).filter(targetMethod -> methodOnDifferentClass.getName().equals(targetMethod.getName())).filter(targetMethod -> methodOnDifferentClass.getParameterCount() == targetMethod.getParameterCount()).collect(Collectors.toList());
            if (sameNameSameParamCount.isEmpty()) {
                return Optional.empty();
            }
            for (Method potential : sameNameSameParamCount) {
                boolean matches = true;
                for (int i = 0; i < potential.getParameters().length; ++i) {
                    Parameter potentialParam = potential.getParameters()[i];
                    Parameter actualParam = methodOnDifferentClass.getParameters()[i];
                    if (potentialParam.getType().isAssignableFrom(actualParam.getType())) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return Optional.of(potential);
            }
            return Optional.empty();
        }
    }
}

