/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.script.ScriptPath;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.file.FileUtil;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class Scripting {
    public static final String SCRIPT_BASE_CLASS = "scriptBaseClass";
    public static final String PATH = "script.path";
    public static final String __DIR = "__dir";
    public static final String __FILE = "__file";
    public static final String __LOAD_DIR = "__load_dir";
    public static final String __LOAD_FILE = "__load_file";
    public static final String __SCRIPT = "__script";
    private static Logger logger = Logger.getLogger();
    private static final Set<String> reservedKeyWords = new HashSet<String>();
    private GroovyEngine engine;
    private List runAfterList = new LinkedList();
    private List launchedList = new LinkedList();
    private ScriptPath scriptPath;
    private boolean silent = false;

    protected Scripting() {
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public static Scripting newInstance(ClassLoader classLoader, Properties properties) {
        Scripting script = new Scripting();
        script.engine = new GroovyEngine(classLoader, properties);
        return script;
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    public boolean containsKey(String key) {
        return this.engine.containsKey(key);
    }

    public void put(String key, Object val) {
        if (reservedKeyWords.contains(key)) {
            throw new SystemException(key + " is a reserved keyword");
        }
        this.privatePut(key, val);
    }

    public void privatePut(String key, Object val) {
        this.engine.put(key, val);
    }

    public Object get(String key) {
        return this.engine.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object t = this.engine.get(key);
        return (T)(t == null ? defaultValue : t);
    }

    public Map<String, Object> getVariables() {
        return this.engine.getVariables();
    }

    public Object remove(String key) {
        return this.engine.remove(key);
    }

    public Properties getProperties() {
        return this.engine.getProperties();
    }

    private String normalizePath(String originalPath) {
        String dir = (String)this.get(__DIR);
        boolean relativePath = false;
        String path = originalPath;
        if (!(dir == null || path.startsWith(dir) || path.startsWith(File.separator) || path.startsWith("/") || path.startsWith("classpath:"))) {
            String prefix;
            int indexOfColon = path.indexOf(58);
            relativePath = indexOfColon > 0 ? (prefix = path.substring(0, indexOfColon)).contains(File.separator) || prefix.contains("/") : true;
        }
        if (relativePath) {
            path = dir + "/" + path;
        }
        return path;
    }

    private Object internalExec(String script, boolean topLevel) throws ScriptException {
        String prevRootDir = null;
        String prevRootFile = null;
        if (topLevel) {
            prevRootDir = (String)this.get(__LOAD_DIR);
            prevRootFile = (String)this.get(__LOAD_FILE);
        }
        ScriptPath prev = this.scriptPath;
        this.scriptPath = new ScriptPath(this.normalizePath(script));
        Reader reader = null;
        try {
            Object object;
            String file;
            String dir = this.scriptPath.getParent();
            if (this.scriptPath.isClassPath()) {
                InputStream stream = this.engine.shell.getClassLoader().getResourceAsStream(this.scriptPath.getFileName());
                if (stream == null) {
                    throw new IOException("File not found: " + this.scriptPath.getClassPath());
                }
                reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                file = this.scriptPath.getFileName();
            } else {
                File f = new File(this.scriptPath.getFileName());
                if (!f.exists()) {
                    throw new IOException("File not found: " + this.scriptPath.getFileName());
                }
                dir = new File(dir).getCanonicalPath();
                file = f.getCanonicalPath();
            }
            this.privatePut(__DIR, dir);
            this.privatePut(__FILE, file);
            if (topLevel) {
                this.privatePut(__LOAD_DIR, dir);
                this.privatePut(__LOAD_FILE, file);
            }
            if (reader != null) {
                object = this.engine.eval(reader, this.scriptPath.getFileName());
                return object;
            }
            object = this.engine.eval(this.scriptPath.getPath().toFile());
            return object;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (ScriptException e) {
            logger.error("Error eval {}", script);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error eval " + script, e);
            throw new SystemException(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            this.scriptPath = prev;
            if (prev != null) {
                this.privatePut(__DIR, prev.getParent());
                this.privatePut(__FILE, prev.getFileName());
            } else {
                this.privatePut(__DIR, null);
                this.privatePut(__FILE, null);
            }
            if (topLevel) {
                this.privatePut(__LOAD_DIR, prevRootDir);
                this.privatePut(__LOAD_FILE, prevRootFile);
            }
        }
    }

    public Object eval(String script) {
        return this.engine.eval(script);
    }

    public Object eval(String script, boolean shouldCache) {
        return this.engine.eval(script, shouldCache);
    }

    public boolean isRunnable(Object obj) {
        return obj instanceof Runnable || obj instanceof Closure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runClosure(Object caller, Closure closure, Object ... args) {
        Object ret = null;
        try {
            Closure clonedClosure = (Closure)closure.clone();
            try {
                clonedClosure.setResolveStrategy(1);
                clonedClosure.setDelegate(caller);
                ret = clonedClosure.call(args);
            }
            finally {
                clonedClosure.setDelegate(null);
            }
        }
        catch (Exception th) {
            logger.warn(th.getMessage(), th);
        }
        return ret;
    }

    public Object runNow(Object caller, Object callable) {
        Object ret = null;
        if (callable instanceof Closure) {
            this.runClosure(caller, (Closure)callable, null);
        } else if (callable instanceof Runnable) {
            ((Runnable)callable).run();
        } else if (callable instanceof Callable) {
            try {
                ret = ((Callable)callable).call();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        } else {
            throw new SystemException("runNow " + callable + " cannot be run");
        }
        return ret;
    }

    public void runAfter(Runnable callable) {
        this.runAfterList.add(callable);
    }

    public void runAfter(Object callable) {
        this.runAfterList.add(callable);
    }

    public void runLaunched(Object callable) {
        this.launchedList.add(callable);
    }

    public void onLaunched() {
        this.executeList(this.launchedList);
        this.launchedList.clear();
    }

    protected String getExtension() {
        return ".groovy";
    }

    public void load(String path) throws ScriptException {
        this.exec(path, true);
        this.runAfter();
    }

    public void load(String loadDir, String path) throws ScriptException {
        String prevRootDir = (String)this.get(__LOAD_DIR);
        String prevRootFile = (String)this.get(__LOAD_FILE);
        try {
            String dir = new File(loadDir).getCanonicalPath();
            String file = new File(path).getCanonicalPath();
            this.privatePut(__LOAD_DIR, dir);
            this.privatePut(__FILE, file);
            this.exec(path, false);
            this.runAfter();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        finally {
            this.privatePut(__LOAD_DIR, prevRootDir);
            this.privatePut(__LOAD_FILE, prevRootFile);
        }
    }

    protected void runAfter() {
        this.executeList(this.runAfterList);
        this.runAfterList.clear();
    }

    private void executeList(List list) {
        Object[] items;
        for (Object obj : items = list.toArray(new Object[list.size()])) {
            if (obj instanceof Closure) {
                ((Closure)obj).call();
                continue;
            }
            if (obj instanceof Runnable) {
                ((Runnable)obj).run();
                continue;
            }
            String clsName = obj == null ? "null" : obj.getClass().getName();
            throw new SystemException("Expecting Closure or Runnable but got " + clsName);
        }
        for (Object obj : items) {
            if (!(obj instanceof Closure)) continue;
            Closure closure = (Closure)obj;
            closure.setDelegate(null);
            Object owner = closure.getOwner();
            if (!(owner instanceof Closure)) continue;
            ((Closure)owner).setDelegate(null);
        }
    }

    public Object exec(String path) throws ScriptException {
        return this.exec(path, false);
    }

    private Object exec(String originalPath, boolean topLevel) throws ScriptException {
        String[] paths;
        try {
            String path = this.normalizePath(originalPath);
            paths = FileUtil.listFiles((ClassLoader)this.engine.shell.getClassLoader(), path, this.getExtension());
            if (!(paths != null && paths.length != 0 || path.endsWith("**") || path.endsWith("*"))) {
                throw new IOException("Script not found " + originalPath);
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        Object ret = null;
        for (String p : paths) {
            Object val;
            if (!this.silent) {
                logger.info("Executing script: {}", p);
            }
            if ((val = this.internalExec(p, topLevel)) == null) continue;
            ret = val;
        }
        return ret;
    }

    public ClassLoader getScriptLoader() {
        return this.engine.getClassLoader();
    }

    static {
        reservedKeyWords.add(__DIR);
        reservedKeyWords.add(__FILE);
    }

    private static class GroovyEngine {
        GroovyShell shell;
        CompilerConfiguration compilerConfig;

        public GroovyEngine(ClassLoader classLoader, Properties properties) {
            ClassLoader ctxLoader = classLoader;
            if (ctxLoader == null) {
                ctxLoader = Thread.currentThread().getContextClassLoader();
            }
            if (ctxLoader == null) {
                ctxLoader = Scripting.class.getClassLoader();
            }
            this.compilerConfig = new CompilerConfiguration();
            this.setCompilerConfig(properties, "groovy.source.encoding", arg_0 -> ((CompilerConfiguration)this.compilerConfig).setSourceEncoding(arg_0), "UTF-8");
            this.setCompilerConfig(properties, "groovy.parameters", value -> this.compilerConfig.setParameters(Boolean.parseBoolean(value)));
            this.setCompilerConfig(properties, "groovy.preview.features", value -> this.compilerConfig.setPreviewFeatures(Boolean.parseBoolean(value)));
            this.setCompilerConfig(properties, "groovy.target.directory", value -> this.compilerConfig.setTargetDirectory(new File((String)value)));
            this.setCompilerConfig(properties, "groovy.target.bytecode", arg_0 -> ((CompilerConfiguration)this.compilerConfig).setTargetBytecode(arg_0));
            this.setCompilerConfig(properties, "groovy.default.scriptExtension", arg_0 -> ((CompilerConfiguration)this.compilerConfig).setDefaultScriptExtension(arg_0));
            String scriptBaseClass = properties.getProperty(Scripting.SCRIPT_BASE_CLASS);
            if (scriptBaseClass != null) {
                this.compilerConfig.setScriptBaseClass(scriptBaseClass);
            }
            GroovyClassLoader loader = new GroovyClassLoader(ctxLoader, this.compilerConfig);
            if (properties.getProperty(Scripting.PATH) != null) {
                loader.addClasspath(properties.getProperty(Scripting.PATH));
            }
            Binding binding = new Binding();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                binding.setVariable(entry.getKey().toString(), entry.getValue());
            }
            this.shell = new GroovyShell((ClassLoader)loader, binding, this.compilerConfig);
        }

        private void setCompilerConfig(Properties properties, String key, Consumer<String> consumer) {
            if (properties.containsKey(key)) {
                consumer.accept(properties.getProperty(key));
            }
        }

        private void setCompilerConfig(Properties properties, String key, Consumer<String> consumer, String defaultValue) {
            if (properties.containsKey(key)) {
                consumer.accept(properties.getProperty(key));
            } else if (System.getProperty(key) == null && defaultValue != null) {
                consumer.accept(defaultValue);
            }
        }

        public void shutdown() {
            try {
                this.shell.getClassLoader().close();
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }

        public boolean containsKey(String key) {
            return this.shell.getContext().getVariables().containsKey(key);
        }

        public void put(String key, Object val) {
            this.shell.setVariable(key, val);
        }

        public Map<String, Object> getVariables() {
            Map binding = this.shell.getContext().getVariables();
            LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : binding.entrySet()) {
                if (entry.getValue() instanceof GString) {
                    variables.put((String)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                variables.put((String)entry.getKey(), entry.getValue());
            }
            return variables;
        }

        public Object get(String key) {
            if ("binding".equals(key)) {
                return this.shell.getContext();
            }
            return this.shell.getVariable(key);
        }

        public Object remove(String key) {
            return this.shell.getContext().getVariables().remove(key);
        }

        public Properties getProperties() {
            Map binding = this.shell.getContext().getVariables();
            Properties properties = new Properties();
            for (Map.Entry key : binding.entrySet()) {
                Object value = binding.get(key);
                if (value == null) continue;
                properties.setProperty(key.toString(), value.toString());
            }
            return properties;
        }

        public Object eval(File file) throws ScriptException {
            Script previous = (Script)this.get(Scripting.__SCRIPT);
            try {
                GroovyCodeSource codeSource = new GroovyCodeSource(file, this.compilerConfig.getSourceEncoding());
                Script script = this.shell.parse(codeSource);
                this.put(Scripting.__SCRIPT, script);
                Object object = script.run();
                return object;
            }
            catch (IOException ex) {
                throw new ScriptException(ex);
            }
            finally {
                if (previous != null) {
                    this.put(Scripting.__SCRIPT, previous);
                } else {
                    this.remove(Scripting.__SCRIPT);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object eval(Reader reader, String fileName) {
            Script previous = (Script)this.get(Scripting.__SCRIPT);
            Object script = null;
            try {
                script = this.shell.parse(reader, GroovyEngine.scriptName(fileName));
                this.put(Scripting.__SCRIPT, script);
                Object object = script.run();
                return object;
            }
            finally {
                if (script != null) {
                    InvokerHelper.removeClass(script.getClass());
                }
                if (previous != null) {
                    this.put(Scripting.__SCRIPT, previous);
                } else {
                    this.remove(Scripting.__SCRIPT);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object eval(String scriptText) {
            Script previous = (Script)this.get(Scripting.__SCRIPT);
            try {
                Script script = this.shell.parse(scriptText);
                this.put(Scripting.__SCRIPT, script);
                Object object = script.run();
                return object;
            }
            finally {
                if (previous != null) {
                    this.put(Scripting.__SCRIPT, previous);
                } else {
                    this.remove(Scripting.__SCRIPT);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object eval(String scriptText, boolean shouldCache) {
            Script previous = (Script)this.get(Scripting.__SCRIPT);
            try {
                GroovyCodeSource codeSource = new GroovyCodeSource(scriptText, "Scripting_Eval.groovy", "/groovy/shell");
                Class cls = this.shell.getClassLoader().parseClass(codeSource, shouldCache);
                Script script = InvokerHelper.createScript((Class)cls, (Binding)this.shell.getContext());
                this.put(Scripting.__SCRIPT, script);
                Object object = script.run();
                return object;
            }
            finally {
                if (previous != null) {
                    this.put(Scripting.__SCRIPT, previous);
                } else {
                    this.remove(Scripting.__SCRIPT);
                }
            }
        }

        public ClassLoader getClassLoader() {
            Script script = (Script)this.get(Scripting.__SCRIPT);
            if (script != null) {
                return script.getMetaClass().getTheClass().getClassLoader();
            }
            return this.shell.getClassLoader();
        }

        private static String scriptName(String fileName) {
            Path path = Paths.get(fileName, new String[0]);
            Path file = path.getFileName();
            if (file.toString().endsWith(".groovy")) {
                int idx = file.toString().lastIndexOf(46);
                String name = file.toString().substring(0, idx);
                name = name + "$script.groovy";
                file = Paths.get(name, new String[0]);
            } else {
                file = Paths.get(file.toString() + "$script", new String[0]);
            }
            Path parent = path.getParent();
            path = Paths.get(parent.toString(), file.toString());
            return path.toString();
        }
    }
}

