/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.file;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.e6tech.elements.common.resources.Provision;

public class FileUtil {
    private static final String[] EMPTY_FILE_LIST = new String[0];
    private static Cache<ClassLoader, List<String>> resourcesCache = CacheBuilder.newBuilder().initialCapacity(20).maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build();

    private FileUtil() {
    }

    public static String[] listFiles(String path, String extension) throws IOException {
        return FileUtil.listFiles(FileUtil.class.getClassLoader(), path, extension);
    }

    public static String[] listFiles(ClassLoader classLoader, String path, String extension) throws IOException {
        String[] paths = EMPTY_FILE_LIST;
        if (path.endsWith("**")) {
            String dir = path.substring(0, path.length() - 2);
            if (classLoader != null && path.startsWith("classpath:")) {
                paths = FileUtil.listClassPaths(classLoader, dir, extension, true);
            } else if (Paths.get(dir, new String[0]).toFile().isDirectory()) {
                paths = FileUtil.listFiles(dir, extension, true);
            }
        } else if (path.endsWith("*")) {
            String dir = path.substring(0, path.length() - 1);
            if (classLoader != null && path.startsWith("classpath:")) {
                paths = FileUtil.listClassPaths(classLoader, dir, extension, false);
            } else if (Paths.get(dir, new String[0]).toFile().isDirectory()) {
                paths = FileUtil.listFiles(dir, extension, false);
            }
        } else {
            paths = FileUtil.getSingleFile(path, extension);
        }
        return paths;
    }

    private static String[] listClassPaths(ClassLoader classLoader, String path, String extension, boolean recursive) throws IOException {
        String fileName = path;
        if (fileName.startsWith("classpath://")) {
            fileName = fileName.substring("classpath://".length());
        } else if (fileName.startsWith("classpath:/")) {
            fileName = fileName.substring("classpath:/".length());
        } else if (fileName.startsWith("classpath:")) {
            fileName = fileName.substring("classpath:".length());
        } else {
            throw new IllegalArgumentException("Invalid classpath " + path);
        }
        while (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        List<String> resources = null;
        try {
            resources = (List)resourcesCache.get((Object)classLoader, () -> {
                ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
                LinkedList<String> found = new LinkedList<String>();
                for (ClassPath.ResourceInfo info : classPath.getResources()) {
                    if (info instanceof ClassPath.ClassInfo) continue;
                    found.add(info.getResourceName());
                }
                return found;
            });
        }
        catch (ExecutionException e) {
            resources = new LinkedList();
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            for (ClassPath.ResourceInfo info : classPath.getResources()) {
                if (info instanceof ClassPath.ClassInfo) continue;
                resources.add(info.getResourceName());
            }
            resourcesCache.put((Object)classLoader, resources);
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String resourceName : resources) {
            if (!resourceName.startsWith(fileName) || !recursive && resourceName.lastIndexOf(47) > fileName.length() || extension != null && !resourceName.endsWith(extension)) continue;
            list.add("classpath://" + resourceName);
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] getSingleFile(String path, String extension) {
        String p;
        String string = p = path.endsWith(extension) ? path : path + extension;
        if (path.startsWith("classpath:")) {
            return new String[]{p};
        }
        File f = new File(p);
        if (!f.isDirectory() && f.exists()) {
            return new String[]{p};
        }
        return EMPTY_FILE_LIST;
    }

    private static String[] listFiles(String path, String extension, boolean recursive) throws IOException {
        LinkedList<String> directories = new LinkedList<String>();
        LinkedList<String> list = new LinkedList<String>();
        if (new File(path).isDirectory()) {
            directories.add(path);
        } else if (extension == null || path.endsWith(extension)) {
            list.add(path);
        }
        while (!directories.isEmpty()) {
            String parent = (String)directories.remove(0);
            Stream<Path> stream = Files.list(Paths.get(parent, new String[0]));
            Throwable throwable = null;
            try {
                stream.forEach(f -> {
                    if (f.toFile().isDirectory()) {
                        if (recursive) {
                            directories.add(f.toString());
                        }
                    } else if (extension == null || f.toString().endsWith(extension)) {
                        list.add(f.toString());
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

