/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.function.FunctionWithException;

public abstract class Balancer<T> {
    private static Logger logger = Logger.getLogger();
    private BlockingQueue<T> liveList = new LinkedBlockingQueue<T>();
    private ConcurrentLinkedQueue<T> processingList = new ConcurrentLinkedQueue();
    private BlockingQueue<T> deadList = new LinkedBlockingQueue<T>();
    private long timeout = 3000L;
    private long recoveryPeriod = 60000L;
    private Thread recoveryThread;
    private volatile boolean stopped = false;
    private boolean threadSafe = false;

    public T getService() {
        Class cls = Reflection.getParametrizedType(this.getClass(), 0);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (proxy, method, args) -> this.execute(service -> method.invoke(service, args)));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getRecoveryPeriod() {
        return this.recoveryPeriod;
    }

    public void setRecoveryPeriod(long recoveryPeriod) {
        this.recoveryPeriod = recoveryPeriod;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void addService(T service) {
        this.liveList.add(service);
    }

    public int getAvailable() {
        return this.liveList.size();
    }

    public void start() {
        Iterator iterator = this.liveList.iterator();
        this.stopped = false;
        while (iterator.hasNext()) {
            Object service = iterator.next();
            try {
                this.start(service);
            }
            catch (Exception th) {
                logger.warn("Cannot start service " + service.getClass(), th);
                iterator.remove();
                this.recover(service);
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }

    protected abstract void start(T var1) throws IOException;

    protected abstract void stop(T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverTask() {
        try {
            this.recovering();
        }
        finally {
            Balancer balancer = this;
            synchronized (balancer) {
                this.recoveryThread = null;
            }
        }
    }

    private void recovering() {
        while (!this.stopped) {
            block7: {
                Object service = null;
                try {
                    service = this.deadList.take();
                    this.start(service);
                    this.liveList.offer(service);
                }
                catch (Exception ex) {
                    if (service == null) break block7;
                    logger.warn("Cannot restart service " + service.getClass(), ex);
                    try {
                        this.stop(service);
                    }
                    catch (Exception e) {
                        logger.warn("Cannot restart service " + service.getClass(), ex);
                    }
                    this.deadList.offer(service);
                }
            }
            try {
                Thread.sleep(this.recoveryPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected synchronized void recover(T service) {
        try {
            this.stop(service);
        }
        catch (Exception e) {
            Logger.suppress(e);
        }
        this.deadList.offer(service);
        if (this.recoveryThread == null) {
            this.recoveryThread = new Thread(this::recoverTask);
            this.recoveryThread.start();
        }
    }

    public <R> R execute(FunctionWithException<T, R, Exception> submit) throws IOException {
        while (true) {
            T service;
            boolean owner = false;
            try {
                service = this.liveList.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (service != null) {
                    this.processingList.offer(service);
                    owner = true;
                }
            }
            catch (InterruptedException e) {
                if (owner) {
                    this.processingList.poll();
                }
                Thread.currentThread().interrupt();
                throw new IOException();
            }
            if (service == null && this.threadSafe) {
                service = this.processingList.peek();
            }
            if (service == null) {
                throw new IOException("No service available");
            }
            SystemException error = null;
            try {
                R ret = submit.apply(service);
                if (owner) {
                    this.liveList.offer(service);
                }
                return ret;
            }
            catch (Exception ex) {
                if (this.shouldRecover(ex)) {
                    if (!owner) continue;
                    this.processingList.poll();
                    this.recover(service);
                    continue;
                }
                if (owner) {
                    this.liveList.offer(service);
                }
                error = ex instanceof SystemException ? (SystemException)ex : (ex instanceof InvocationTargetException ? new SystemException(ex.getCause()) : (ex instanceof RuntimeException ? new SystemException(ex.getCause()) : new SystemException(ex)));
                if (error == null) continue;
                throw error;
            }
            break;
        }
    }

    protected boolean shouldRecover(Exception exception) {
        Throwable throwable = ExceptionMapper.unwrap(exception);
        return throwable instanceof IOException;
    }
}

