/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.resources.AlreadyBoundException;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;

class ResourcesState {
    private static final List<ResourceProvider> emptyResourceProviders = Collections.unmodifiableList(new ArrayList());
    private static final String CLASS_MSG = "Class ";
    private static final String BOUND_TO_MSG = " is already bound to ";
    private ModuleFactory factory;
    private Module module;
    private Injector injector;
    private State state = State.INITIAL;
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private LinkedList<Object> injectionList = new LinkedList();
    private List<ResourceProvider> externalResourceProviders;
    private Map<String, Object> variables;

    ResourcesState(Resources resources) {
        this.factory = resources.getResourceManager().getModule().getFactory();
        this.module = this.factory.create();
    }

    protected void cleanup() {
        this.module = this.factory.create();
        this.resourceProviders.clear();
        this.state = State.INITIAL;
        this.injectionList.clear();
        this.injector = null;
        this.externalResourceProviders = null;
    }

    public Module getModule() {
        return this.module;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public void setResourceProviders(List<ResourceProvider> resourceProviders) {
        this.resourceProviders = resourceProviders;
    }

    List<ResourceProvider> getExternalResourceProviders() {
        if (this.externalResourceProviders == null) {
            return emptyResourceProviders;
        }
        return this.externalResourceProviders;
    }

    void setExternalResourceProviders(List<ResourceProvider> externalResourceProviders) {
        this.externalResourceProviders = externalResourceProviders;
    }

    public void addModule(Module module) {
        this.module.add(module);
    }

    protected void onOpen(Resources resources) {
        if (!this.injectionList.isEmpty()) {
            this.createInjector(resources);
        }
    }

    protected Injector createInjector(Resources resources) {
        if (this.injector == null || !this.injectionList.isEmpty()) {
            Injector injector = this.injector = resources.getResourceManager() != null ? this.getModule().build(resources.getResourceManager().getModule()) : this.getModule().build(new Module[0]);
            while (!this.injectionList.isEmpty()) {
                Object obj = this.injectionList.remove();
                this.privateInject(resources, this.injector, obj);
            }
        }
        return this.injector;
    }

    public <T> T inject(Resources resources, T object) {
        if (object == null) {
            return object;
        }
        if (this.state == State.INITIAL) {
            this.injectionList.add(object);
        } else {
            this.createInjector(resources);
            this.privateInject(resources, this.injector, object);
        }
        return object;
    }

    protected void privateInject(Resources resources, Injector injector, Object object) {
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).preInject(resources);
        }
        injector.inject(object);
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).injected(resources);
        }
    }

    public <T> T tryBind(Class<T> cls, Callable<T> callable) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            return o;
        }
        Object instance = null;
        try {
            instance = this.getModule().bindInstance(cls, callable.call());
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return (T)instance;
    }

    public <T> T bind(Class<T> cls, T resource) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            throw new AlreadyBoundException(CLASS_MSG + cls + BOUND_TO_MSG + o);
        }
        return (T)this.getModule().bindInstance(cls, resource);
    }

    public <T> T rebind(Class<T> cls, T resource) {
        Object instance = null;
        try {
            instance = this.getModule().rebindInstance(cls, resource);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return (T)instance;
    }

    public <T> T unbind(Class<T> cls) {
        Object instance = null;
        try {
            instance = this.getModule().unbindInstance(cls);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return (T)instance;
    }

    public void bindClass(Class cls, Class service) {
        Class c = this.getModule().getBoundClass(cls);
        if (c != null) {
            throw new AlreadyBoundException(CLASS_MSG + cls + BOUND_TO_MSG + c);
        }
        if (service != null) {
            this.getModule().bindClass(cls, service);
        } else {
            this.getModule().bindInstance(cls, null);
        }
    }

    public <T> T bindNamedInstance(Class<T> cls, String name, T resource) {
        T o = this.getModule().getBoundNamedInstance(cls, name);
        if (o != null) {
            throw new AlreadyBoundException(CLASS_MSG + cls + BOUND_TO_MSG + o);
        }
        return this.rebindNamedInstance(cls, name, resource);
    }

    public <T> T rebindNamedInstance(Class<T> cls, String name, T resource) {
        return (T)this.getModule().rebindNamedInstance(cls, name, resource);
    }

    public <T> T getNamedInstance(Resources resources, Class<T> cls, String name) {
        T instance = null;
        if (this.state == State.INITIAL) {
            if (this.getModule().getBoundNamedInstance(cls, name) != null) {
                instance = this.getModule().getBoundNamedInstance(cls, name);
            } else if (resources.getResourceManager().getModule().getBoundNamedInstance(cls, name) != null) {
                instance = resources.getResourceManager().getModule().getBoundNamedInstance(cls, name);
            }
        } else {
            instance = this.createInjector(resources).getNamedInstance(cls, name);
        }
        if (instance == null) {
            throw new InstanceNotFoundException("No instance for class " + cls.getName() + ". Use newInstance if you meant to create an instance.");
        }
        return instance;
    }

    public boolean hasInstance(Resources resources, Class cls) {
        if (cls.isAssignableFrom(Resources.class) || cls.isAssignableFrom(ResourceManager.class)) {
            return true;
        }
        return this.getModule().getBoundInstance(cls) != null || resources.getResourceManager().hasInstance(cls);
    }

    public <T> T getInstance(Resources resources, Class<T> cls) {
        if (cls.isAssignableFrom(Resources.class)) {
            return (T)resources;
        }
        if (cls.isAssignableFrom(ResourceManager.class)) {
            return (T)resources.getResourceManager();
        }
        T instance = null;
        if (this.state == State.INITIAL) {
            if (this.getModule().getBoundInstance(cls) != null) {
                instance = this.getModule().getBoundInstance(cls);
            } else if (resources.getResourceManager().hasInstance(cls)) {
                instance = resources.getResourceManager().getInstance(cls);
            }
        } else {
            instance = this.createInjector(resources).getInstance(cls);
        }
        if (instance == null) {
            throw new InstanceNotFoundException("No instance for class " + cls.getName() + ". Use newInstance if you meant to create an instance.");
        }
        return instance;
    }

    public <T> Optional<T> getVariable(String key) {
        if (this.variables == null) {
            return Optional.empty();
        }
        Object t = this.variables.get(key);
        return Optional.ofNullable(t);
    }

    public void setVariable(String key, Object val) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, val);
    }

    public <T> Map<String, T> computeMapIfAbsent(Class<T> key) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        return (Map)this.variables.computeIfAbsent(key.toString(), k -> new LinkedHashMap());
    }

    static enum State {
        INITIAL,
        OPEN,
        COMMITTED,
        ABORTED;

    }
}

