/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.e6tech.elements.common.logging.ConsoleLogger;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.logging.LoggerExtension;
import net.e6tech.elements.common.util.SystemException;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.LoggerFactory;

public class LogHandler
implements InvocationHandler {
    private static final String LOG_DIR = "logDir";
    private static String logDir;
    private static ConsoleLogger consoleLogger;
    private org.slf4j.Logger slf4jLogger;
    private Class loggingClass;
    private String loggingName;
    private LogLevel level = LogLevel.ERROR;
    private LoggerExtension loggerExtension = new LoggerExtension(){

        @Override
        public Logger logger(LogLevel level) {
            LogHandler handler = new LogHandler(LogHandler.this.slf4jLogger);
            handler.level = level;
            if (LogHandler.this.loggingClass != null) {
                handler.loggingClass = LogHandler.this.loggingClass;
            }
            if (LogHandler.this.loggingName != null) {
                handler.loggingName = LogHandler.this.loggingName;
            }
            return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)handler);
        }

        @Override
        public void log(String msg, Throwable e) {
            this.logWithLevel(LogHandler.this.level, msg, e);
        }

        @Override
        public Logger log(LogLevel l, String msg, Throwable e) {
            Logger logger = this.logger(l);
            logger.log(msg, e);
            return logger;
        }

        @Override
        public SystemException systemException(String msg, Throwable th) {
            SystemException t = LoggerExtension.super.systemException(msg, th);
            this.logWithLevel(LogHandler.this.level, msg, th);
            return t;
        }

        @Override
        public <T extends Throwable> T exception(Class<T> exceptionClass, String msg, Throwable e) {
            T t = LoggerExtension.super.exception(exceptionClass, msg, e);
            this.logWithLevel(LogHandler.this.level, msg, e);
            return t;
        }

        private void logWithLevel(LogLevel l, String msg, Throwable e) {
            if (LogHandler.this.getLogger() != null) {
                switch (l) {
                    case FATAL: 
                    case ERROR: {
                        LogHandler.this.getLogger().error(msg, e);
                        break;
                    }
                    case WARN: {
                        LogHandler.this.getLogger().warn(msg, e);
                        break;
                    }
                    case INFO: {
                        LogHandler.this.getLogger().info(msg, e);
                        break;
                    }
                    case DEBUG: {
                        LogHandler.this.getLogger().debug(msg, e);
                        break;
                    }
                    case TRACE: {
                        LogHandler.this.getLogger().trace(msg, e);
                        break;
                    }
                    default: {
                        LogHandler.this.getLogger().warn(msg, e);
                        break;
                    }
                }
            } else {
                System.out.println(msg);
                e.printStackTrace(System.out);
            }
        }
    };

    LogHandler(org.slf4j.Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    LogHandler(Class cls) {
        this.loggingClass = cls;
    }

    LogHandler(String name) {
        this.loggingName = name;
    }

    protected org.slf4j.Logger getLogger() {
        if (this.slf4jLogger != null) {
            return this.slf4jLogger;
        }
        if (this.loggingClass == null && this.loggingName == null) {
            return null;
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            return consoleLogger;
        }
        if (ThreadContext.get((String)LOG_DIR) == null) {
            if (logDir == null) {
                if (System.getProperty(LOG_DIR) != null) {
                    logDir = System.getProperty(LOG_DIR);
                } else if (System.getProperty("elements.common.logging.logDir") != null) {
                    logDir = System.getProperty("elements.common.logging.logDir");
                }
            }
            if (logDir == null) {
                return consoleLogger;
            }
            ThreadContext.put((String)LOG_DIR, (String)logDir);
        }
        this.slf4jLogger = this.loggingClass != null ? LoggerFactory.getLogger((Class)this.loggingClass) : LoggerFactory.getLogger((String)this.loggingName);
        this.loggingClass = null;
        this.loggingName = null;
        return this.slf4jLogger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(LoggerExtension.class)) {
            return method.invoke((Object)this.loggerExtension, args);
        }
        org.slf4j.Logger logger = this.getLogger();
        if (logger == null) {
            return null;
        }
        return method.invoke((Object)logger, args);
    }

    static {
        System.setProperty("java.util.logging.manager", "net.e6tech.elements.common.logging.jul.LogManager");
        consoleLogger = new ConsoleLogger();
    }
}

