/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.monitor;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.e6tech.elements.common.util.monitor.AllocationListener;
import net.e6tech.elements.common.util.monitor.DeallocationListener;
import net.e6tech.elements.common.util.monitor.LeakListener;

public class AllocationMonitor {
    private ReferenceQueue<Object> phantoms = new ReferenceQueue();
    private Thread deallocThread = new Thread();
    private final SortedSet<AllocationReference> allocated;
    private long checkInterval = 60000L;
    private long expired = 60000L;
    private boolean disabled = false;

    public AllocationMonitor() {
        Comparator<AllocationReference> comparator = Comparator.comparingLong(l -> l.expiredTime);
        this.allocated = Collections.synchronizedSortedSet(new TreeSet<AllocationReference>(comparator));
    }

    public void monitorLeak(long timeout, Object obj, LeakListener listener) {
        if (this.disabled) {
            return;
        }
        long realTimeout = timeout;
        if (realTimeout <= 0L) {
            realTimeout = this.expired;
        }
        this.allocated.add(new AllocationReference(realTimeout, obj, this.phantoms, listener));
        this.checkGCThread();
    }

    public void monitorDealloc(Object obj, DeallocationListener listener) {
        if (this.disabled) {
            return;
        }
        this.allocated.add(new AllocationReference(0L, obj, this.phantoms, listener));
        this.checkGCThread();
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getExpired() {
        return this.expired;
    }

    public void setExpired(long expired) {
        this.expired = expired;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public synchronized void shutdown() {
        if (this.deallocThread.isAlive()) {
            this.deallocThread.interrupt();
        }
        this.allocated.clear();
        this.phantoms = new ReferenceQueue();
    }

    protected synchronized void checkGCThread() {
        if (this.deallocThread.isAlive()) {
            return;
        }
        Thread leakThread = new Thread(() -> {
            Object wait = new Object();
            try {
                while (true) {
                    Object object = this.allocated;
                    synchronized (object) {
                        Iterator iterator = this.allocated.iterator();
                        while (iterator.hasNext()) {
                            AllocationReference alloc = (AllocationReference)iterator.next();
                            if (System.currentTimeMillis() <= alloc.expiredTime) break;
                            alloc.getListener().onPotentialLeak();
                            iterator.remove();
                        }
                    }
                    object = wait;
                    synchronized (object) {
                        wait.wait(this.checkInterval);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.deallocThread = new Thread(() -> {
            try {
                while (true) {
                    Reference<Object> ref = this.phantoms.remove();
                    this.allocated.remove(ref);
                    if (!(ref instanceof AllocationReference)) continue;
                    AllocationReference alloc = (AllocationReference)ref;
                    alloc.listener.onDeallocated();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                leakThread.interrupt();
                return;
            }
        });
        leakThread.setDaemon(true);
        leakThread.start();
        this.deallocThread.setDaemon(true);
        this.deallocThread.start();
    }

    static class AllocationReference
    extends PhantomReference<Object> {
        AllocationListener listener;
        long startTime;
        long expiredTime;

        public AllocationReference(long timeout, Object referent, ReferenceQueue q, AllocationListener listener) {
            super(referent, q);
            this.expiredTime = timeout == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
            this.listener = listener;
        }

        public AllocationListener getListener() {
            return this.listener;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

