/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.datastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinarySearchList<T extends Comparable>
implements Iterable<T> {
    private List<T> sortedList = new ArrayList<T>();

    @Override
    public Iterator<T> iterator() {
        return this.sortedList.iterator();
    }

    public int size() {
        return this.sortedList.size();
    }

    public boolean add(T cmp) {
        this.privateAdd(0, this.sortedList.size() - 1, cmp);
        return true;
    }

    public void check() {
        Comparable prev = null;
        for (Comparable c : this.sortedList) {
            if (prev == null) {
                prev = c;
            }
            if (prev.compareTo(c) <= 0) continue;
            throw new IllegalStateException();
        }
    }

    public T get(int i) {
        return (T)((Comparable)this.sortedList.get(i));
    }

    private void privateAdd(int min, int max, T cmp) {
        if (this.size() == 0) {
            this.sortedList.add(cmp);
            return;
        }
        if (min == max) {
            T candidate = this.get(min);
            int order = candidate.compareTo(cmp);
            if (order == 0 || order > 0) {
                this.sortedList.add(min, cmp);
            } else if (candidate.compareTo(cmp) < 0) {
                this.sortedList.add(min + 1, cmp);
            }
            return;
        }
        int index = (max + min + 1) / 2;
        T candidate = this.get(index);
        if (candidate.compareTo(cmp) == 0) {
            this.sortedList.add(index, cmp);
        } else if (candidate.compareTo(cmp) > 0) {
            this.privateAdd(min, (max + min) / 2, cmp);
        } else if (candidate.compareTo(cmp) < 0) {
            this.privateAdd(index, max, cmp);
        }
    }

    public boolean removeAll(T cmp) {
        return this._remove(0, this.sortedList.size() - 1, cmp, false);
    }

    public boolean removeFirst(T cmp) {
        return this._remove(0, this.sortedList.size() - 1, cmp, true);
    }

    private boolean _remove(int min, int max, T cmp, boolean onlyOne) {
        if (this.size() == 0) {
            return false;
        }
        if (min == max) {
            T candidate = this.get(min);
            int order = candidate.compareTo(cmp);
            if (order == 0) {
                T left;
                T right;
                int i;
                int modifiableSize = this.size();
                boolean found = false;
                for (i = min; i < modifiableSize && (right = this.get(i)).compareTo(cmp) == 0; ++i) {
                    if (!right.equals(cmp)) continue;
                    this.sortedList.remove(i);
                    --i;
                    --modifiableSize;
                    found = true;
                    if (!onlyOne) continue;
                    return true;
                }
                for (i = min - 1; i >= 0 && (left = this.get(i)).compareTo(cmp) == 0; --i) {
                    if (!left.equals(cmp)) continue;
                    this.sortedList.remove(i);
                    found = true;
                    if (!onlyOne) continue;
                    return true;
                }
                return found;
            }
            return false;
        }
        int index = (max + min + 1) / 2;
        T candidate = this.get(index);
        if (candidate.compareTo(cmp) == 0) {
            return this._remove(index, index, cmp, onlyOne);
        }
        if (candidate.compareTo(cmp) > 0) {
            return this._remove(min, (max + min) / 2, cmp, onlyOne);
        }
        if (candidate.compareTo(cmp) < 0) {
            return this._remove(index, max, cmp, onlyOne);
        }
        return false;
    }
}

