/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Interfaces {
    private Interfaces() {
    }

    public static Type getGenericType(Class cls, Class intf, int n) {
        TypeInfo head = Interfaces.getGenericType(cls, intf);
        if (head == null) {
            return null;
        }
        return head.getSourceType(n);
    }

    private static TypeInfo getGenericType(Class cls, Class intf) {
        if (!intf.isInterface()) {
            throw new IllegalArgumentException(intf.getName() + " is not an interface");
        }
        TypeInfo head = null;
        ArrayList<ParameterizedType> list = new ArrayList<ParameterizedType>();
        block0: for (Class clazz = cls; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                list.add((ParameterizedType)clazz.getGenericSuperclass());
            }
            for (Type type : clazz.getGenericInterfaces()) {
                ParameterizedType ptype;
                if (!(type instanceof ParameterizedType) || !intf.isAssignableFrom((Class)(ptype = (ParameterizedType)type).getRawType())) continue;
                list.add(ptype);
                Interfaces.tracePath((Class)ptype.getRawType(), intf, list);
                Collections.reverse(list);
                ParameterizedType root = (ParameterizedType)list.remove(0);
                TypeInfo prev = head = new TypeInfo(root);
                for (ParameterizedType p : list) {
                    prev = prev.linkPrevious(p);
                }
                prev.close();
                continue block0;
            }
        }
        return head;
    }

    private static void tracePath(Class start, Class end, List<ParameterizedType> list) {
        for (Type type : start.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType ptype = (ParameterizedType)type;
            if (ptype.getRawType().equals(end)) {
                list.add(ptype);
                break;
            }
            if (!end.isAssignableFrom((Class)ptype.getRawType())) continue;
            list.add(ptype);
            Interfaces.tracePath((Class)ptype.getRawType(), end, list);
            break;
        }
    }

    private static class TypeInfo {
        private ParameterizedType type;
        private List jumpTable = new ArrayList();
        private TypeInfo previousInfo;

        public TypeInfo(ParameterizedType type) {
            this.type = type;
        }

        public TypeInfo linkPrevious(ParameterizedType previous) {
            Class cls = (Class)previous.getRawType();
            for (Type t : this.type.getActualTypeArguments()) {
                if (t instanceof Class) {
                    this.jumpTable.add(t);
                    continue;
                }
                if (!(t instanceof TypeVariable)) continue;
                TypeVariable var = (TypeVariable)t;
                TypeVariable<Class<T>>[] previousVars = cls.getTypeParameters();
                Object jump = var;
                for (int i = 0; i < previousVars.length; ++i) {
                    if (!var.getName().equals(previousVars[i].getName())) continue;
                    jump = i;
                    break;
                }
                this.jumpTable.add(jump);
            }
            this.previousInfo = new TypeInfo(previous);
            return this.previousInfo;
        }

        public void close() {
            for (Type t : this.type.getActualTypeArguments()) {
                this.jumpTable.add(t);
            }
        }

        public Type getSourceType(int n) {
            Object obj = this.jumpTable.get(n);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Integer && this.previousInfo != null) {
                return this.previousInfo.getSourceType((Integer)obj);
            }
            if (obj instanceof Type) {
                return (Type)obj;
            }
            return null;
        }
    }
}

