/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.Scheduler;
import akka.actor.typed.Signal;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.Adapter;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.e6tech.elements.common.actor.typed.Ask;
import net.e6tech.elements.common.actor.typed.Asking;
import net.e6tech.elements.common.actor.typed.ExtensionEvents;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Spawn;
import net.e6tech.elements.common.actor.typed.Talk;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public abstract class Receptor<T, R extends Receptor<T, R>> {
    private static Cache<Class, List<MessageBuilder>> cache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(1000L).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
    private static Cache<Method, BiConsumer> eventCache = CacheBuilder.newBuilder().concurrencyLevel(64).initialCapacity(128).maximumSize(10000L).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
    private static Cache<Method, BiFunction> interceptorCache = CacheBuilder.newBuilder().concurrencyLevel(64).initialCapacity(128).maximumSize(10000L).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
    private Guardian guardian;
    private AbstractBehavior<T> behavior;
    protected List<Receptor> addedExtensions = new ArrayList<Receptor>();
    protected Map<Class, Receptor> extensions = new LinkedHashMap<Class, Receptor>();

    protected <U extends Receptor> U addExtension(U trait) {
        this.addedExtensions.add(trait);
        return trait;
    }

    public Behavior<T> setup(akka.actor.typed.javadsl.ActorContext<T> context, Guardian guardian) {
        this.guardian = guardian;
        this.behavior = new AbstractBehavior<T>(context){

            public Receive<T> createReceive() {
                return Receptor.this.createReceive();
            }
        };
        this.initialize();
        return this.behavior;
    }

    public R virtualize() {
        long timeout = this.getGuardian() != null ? this.getGuardian().getTimeout() : 5000L;
        return (R)Interceptor.getInstance().interceptorBuilder(this, new ReceptorInterceptorHandler(timeout)).build();
    }

    public R virtualize(long timeout) {
        return (R)Interceptor.getInstance().interceptorBuilder(this, new ReceptorInterceptorHandler(timeout)).build();
    }

    public Behavior<T> create() {
        return this.behavior;
    }

    public Behavior<T> getBehavior() {
        return this.behavior;
    }

    protected void initialize() {
    }

    @Typed
    public ExtensionEvents.ExtensionsResponse extensions(ExtensionEvents.Extensions event) {
        return new ExtensionEvents.ExtensionsResponse(this.getSelf(), this, new LinkedHashMap<Class, Receptor>(this.extensions));
    }

    private void saveEventClass(Class cls, Receptor implementation) {
        Class c = cls;
        Class eventClass = null;
        while (!c.equals(Receptor.class)) {
            try {
                eventClass = Reflection.getParametrizedType(c, 0);
                if (eventClass != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        if (eventClass != null && !this.extensions.containsKey(eventClass)) {
            this.extensions.put(eventClass, implementation);
        }
    }

    protected Receive<T> createReceive() {
        ReceiveBuilder builder = this.behavior.newReceiveBuilder();
        Class<?> cls = this.getClass();
        this.saveEventClass(cls, this);
        HashSet<String> events = new HashSet<String>();
        while (true) {
            builder = this.build(this, builder, cls, events);
            if (cls.equals(Receptor.class)) break;
            cls = cls.getSuperclass();
        }
        block1: for (Receptor extension : this.addedExtensions) {
            extension.setup(this.getContext(), this.getGuardian());
            cls = extension.getClass();
            this.saveEventClass(cls, extension);
            while (true) {
                builder = this.build(extension, builder, cls, events);
                if (cls.equals(Receptor.class)) continue block1;
                cls = cls.getSuperclass();
            }
        }
        this.addedExtensions.clear();
        this.addedExtensions = null;
        return builder.build();
    }

    private ReceiveBuilder build(Receptor target, ReceiveBuilder builder, Class cls, Set<String> events) {
        ArrayList<MessageBuilder> list = (ArrayList<MessageBuilder>)cache.getIfPresent((Object)cls);
        if (list == null) {
            list = new ArrayList<MessageBuilder>();
            for (Method method : cls.getDeclaredMethods()) {
                Typed typed = method.getAnnotation(Typed.class);
                if (typed == null) continue;
                if (method.getParameterCount() == 1) {
                    method.setAccessible(true);
                    if (Signal.class.isAssignableFrom(method.getParameterTypes()[0])) {
                        list.add(new OnSignal(method));
                        continue;
                    }
                    list.add(new OnMessage(method));
                    continue;
                }
                throw new SystemException("Invalid method signature for method " + method);
            }
            cache.put((Object)cls, list);
        }
        for (MessageBuilder mb : list) {
            if (events.contains(mb.signature())) continue;
            events.add(mb.signature());
            builder = mb.build(builder, target);
        }
        return builder;
    }

    public akka.actor.typed.javadsl.ActorContext<T> getContext() {
        return this.behavior.getContext();
    }

    public ActorSystem<Void> getSystem() {
        return this.getContext().getSystem();
    }

    public Talk<T> talk() {
        return new Talk<T>(this.getGuardian(), this.getSelf());
    }

    public <U> Talk<U> talk(Class<U> cls) {
        return new Talk(this.getGuardian(), this.getSelf().unsafeUpcast());
    }

    public Talk<T> talk(long timeout) {
        return this.talk().timeout(timeout);
    }

    public <U> Talk<U> talk(akka.actor.typed.ActorRef<U> recipient) {
        return new Talk<U>(this.getGuardian(), recipient);
    }

    public <U> Talk<U> talk(akka.actor.typed.ActorRef<U> recipient, long timeout) {
        return new Talk<U>(this.getGuardian(), recipient).timeout(timeout);
    }

    public <U, V> Talk<V> talk(akka.actor.typed.ActorRef<U> recipient, Class<V> cls) {
        akka.actor.typed.ActorRef ref = recipient.unsafeUpcast();
        return new Talk(this.getGuardian(), ref);
    }

    public <U, V> Talk<V> talk(akka.actor.typed.ActorRef<U> recipient, Class<V> cls, long timeout) {
        akka.actor.typed.ActorRef ref = recipient.unsafeUpcast();
        return new Talk(this.getGuardian(), ref).timeout(timeout);
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public akka.actor.typed.ActorRef<T> getSelf() {
        return this.getContext().getSelf();
    }

    public Scheduler getScheduler() {
        return this.getSystem().scheduler();
    }

    public <C extends Receptor<M, C>, M> Spawn<M, C> childActor(Class<C> commonBehaviorClass) {
        return new Spawn(this);
    }

    public ActorRef untypedRef() {
        return Adapter.toClassic(this.getSelf());
    }

    public ActorContext untypedContext() {
        return Adapter.toClassic(this.getContext());
    }

    public ActorRef actorOf(Props props, String name) {
        return this.untypedContext().actorOf(props, name);
    }

    public ActorRef actorOf(Props props) {
        return this.untypedContext().actorOf(props);
    }

    class ReceptorInterceptorHandler
    implements InterceptorHandler {
        private long timeout;
        private Receptor enclosing;

        ReceptorInterceptorHandler(long timeout) {
            this.timeout = timeout;
            this.enclosing = Receptor.this;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        private Talk talk() {
            return this.enclosing.talk(this.timeout);
        }

        @Override
        public Object invoke(CallFrame frame) {
            BiFunction<ReceptorInterceptorHandler, CallFrame, Object> biFunction = (BiFunction<ReceptorInterceptorHandler, CallFrame, Object>)interceptorCache.getIfPresent((Object)frame.getMethod());
            if (biFunction == null) {
                if (frame.getMethod().getAnnotation(Typed.class) != null && frame.getMethod().getParameterTypes().length > 0) {
                    Class<?> argType = frame.getMethod().getParameterTypes()[0];
                    biFunction = !frame.getMethod().getReturnType().equals(Void.TYPE) && !frame.getMethod().getReturnType().equals(Void.class) ? (Ask.class.isAssignableFrom(argType) ? (handler, f) -> handler.talk().askAndWait(sender -> {
                        Object arg = f.getArguments()[0];
                        ((Ask)arg).setSender((akka.actor.typed.ActorRef)sender);
                        return arg;
                    }) : (Asking.class.isAssignableFrom(argType) ? (handler, f) -> handler.talk().askAndWait(sender -> {
                        Object arg = f.getArguments()[0];
                        ((Asking)arg).setSender((akka.actor.typed.ActorRef)sender);
                        return arg;
                    }) : (handler, f) -> {
                        throw new SystemException("Event " + f.getMethod().getParameterTypes()[0] + " is not a subclass of Ask nor does it implement Asking.");
                    })) : (handler, f) -> {
                        Object arg = f.getArguments()[0];
                        handler.talk().tell(arg);
                        return null;
                    };
                    interceptorCache.put((Object)frame.getMethod(), biFunction);
                } else {
                    biFunction = (handler, f) -> f.invoke();
                    interceptorCache.put((Object)frame.getMethod(), biFunction);
                }
            }
            return biFunction.apply(this, frame);
        }
    }

    static class OnSignal
    extends MessageBuilder {
        OnSignal(Method method) {
            super(method);
        }

        @Override
        public ReceiveBuilder build(ReceiveBuilder builder, Object target) {
            return builder.onSignal(this.method.getParameterTypes()[0], (Function & Serializable)m -> {
                Object ret = this.method.invoke(target, m);
                return this.behavior ? ret : Behaviors.same();
            });
        }
    }

    static class OnMessage
    extends MessageBuilder {
        private static final BiConsumer<Object, Object> NO_OP = (arg, ret) -> {};

        OnMessage(Method method) {
            super(method);
        }

        @Override
        public ReceiveBuilder build(ReceiveBuilder builder, Object target) {
            BiConsumer<Object, Object> consumer = (BiConsumer<Object, Object>)eventCache.getIfPresent((Object)this.method);
            if (consumer == null) {
                consumer = NO_OP;
                if (this.method.getParameterTypes().length > 0 && !this.method.getReturnType().equals(Void.TYPE) && !this.method.getReturnType().equals(Void.class)) {
                    Class<?> argType = this.method.getParameterTypes()[0];
                    if (Ask.class.isAssignableFrom(argType)) {
                        consumer = (arg, ret) -> {
                            akka.actor.typed.ActorRef sender = ((Ask)arg).getSender();
                            if (sender != null) {
                                try {
                                    sender.tell(ret);
                                }
                                catch (Exception th) {
                                    sender.tell((Object)new Status.Failure((Throwable)th));
                                }
                            }
                        };
                    } else if (Asking.class.isAssignableFrom(argType)) {
                        consumer = (arg, ret) -> {
                            akka.actor.typed.ActorRef sender = ((Asking)arg).getSender();
                            if (sender != null) {
                                try {
                                    sender.tell(ret);
                                }
                                catch (Exception th) {
                                    sender.tell((Object)new Status.Failure((Throwable)th));
                                }
                            }
                        };
                    }
                }
                eventCache.put((Object)this.method, consumer);
            }
            BiConsumer<Object, Object> responder = consumer;
            return builder.onMessage(this.method.getParameterTypes()[0], (Function & Serializable)m -> {
                Object ret = this.method.invoke(target, m);
                responder.accept(m, ret);
                return this.behavior ? ret : Behaviors.same();
            });
        }
    }

    static abstract class MessageBuilder {
        protected boolean behavior;
        protected Method method;
        private String signature;

        MessageBuilder(Method method) {
            this.behavior = Behavior.class.isAssignableFrom(method.getReturnType());
            this.method = method;
            StringBuilder builder = new StringBuilder();
            builder.append(method.getName());
            builder.append("(");
            boolean first = true;
            for (Class<?> param : method.getParameterTypes()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(param.getTypeName());
            }
            builder.append(")");
            this.signature = builder.toString();
        }

        abstract ReceiveBuilder build(ReceiveBuilder var1, Object var2);

        String signature() {
            return this.signature;
        }
    }
}

