/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;

public class ResourcesBuilder<T extends Annotation> {
    private Provision provision;
    private Class<T> annotationClass;
    private List<Consumer<Resources>> consumers = new ArrayList<Consumer<Resources>>();

    ResourcesBuilder(Provision provision, Class<T> annotationClass) {
        this.provision = provision;
        this.annotationClass = annotationClass;
    }

    public <K extends Annotation> ResourcesBuilder another(Class<K> anotherClass) {
        ResourcesBuilder<K> newInstance = new ResourcesBuilder<K>(this.provision, anotherClass);
        newInstance.consumers = this.consumers;
        return newInstance;
    }

    public UnitOfWork preOpen(Consumer<Resources> consumer) {
        if (this.consumers.isEmpty()) {
            return this.provision.preOpen(consumer);
        }
        return this.provision.preOpen(res -> {
            this.consumers.forEach(c -> c.accept(res));
            if (consumer != null) {
                consumer.accept((Resources)res);
            }
        });
    }

    public UnitOfWork open() {
        if (this.consumers.isEmpty()) {
            return this.provision.preOpen(null);
        }
        return this.provision.preOpen(res -> this.consumers.forEach(c -> c.accept(res)));
    }

    public <U> ResourcesBuilder<T> annotate(Function<T, Callable<U>> func, U value) {
        this.consumers.add(res -> res.configurator().annotate(this.annotationClass, (annotationValue, annotation) -> annotationValue.set((Callable)func.apply(annotation), value)));
        return this;
    }
}

