/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.Status;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import net.e6tech.elements.common.actor.typed.WorkEvents;

public class Worker
extends AbstractBehavior<WorkEvents> {
    private ActorRef pool;
    private ActorContext context;

    public Worker(ActorContext context, ActorRef pool) {
        this.pool = pool;
        this.context = context;
    }

    public Receive<WorkEvents> createReceive() {
        return this.newReceiveBuilder().onMessage(WorkEvents.RunnableTask.class, this::run).onMessage(WorkEvents.CallableTask.class, this::call).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Behavior<WorkEvents> run(WorkEvents.RunnableTask message) {
        ActorRef self = this.context.getSelf();
        try {
            message.getRunnable().run();
            message.getSender().tell((Object)new WorkEvents.Response());
        }
        catch (Exception th) {
            message.getSender().tell((Object)new Status.Failure((Throwable)th));
        }
        finally {
            this.pool.tell((Object)new WorkEvents.IdleWorker(self));
        }
        return Behaviors.same();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Behavior<WorkEvents> call(WorkEvents.CallableTask message) {
        ActorRef self = this.context.getSelf();
        try {
            Object ret = message.getCallable().call();
            message.getSender().tell((Object)new WorkEvents.Response(ret));
        }
        catch (Exception th) {
            message.getSender().tell((Object)new Status.Failure((Throwable)th));
        }
        finally {
            this.pool.tell((Object)new WorkEvents.IdleWorker(self));
        }
        return Behaviors.same();
    }
}

