/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor;

import akka.actor.ActorContext;
import akka.actor.PoisonPill;
import akka.actor.Scheduler;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.Props;
import akka.actor.typed.RecipientRef;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.Adapter;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.Guardian;
import net.e6tech.elements.common.actor.Typed;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public abstract class CommonBehavior<T>
extends AbstractBehavior<T> {
    private static Cache<Class, Receive> cache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(100L).build();
    private akka.actor.typed.javadsl.ActorContext<T> context;
    private Guardian guardian;

    public Receive<T> createReceive() {
        Receive receive = (Receive)cache.getIfPresent(((Object)((Object)this)).getClass());
        if (receive != null) {
            return receive;
        }
        ReceiveBuilder builder = this.newReceiveBuilder();
        Class<?> cls = ((Object)((Object)this)).getClass();
        HashSet events = new HashSet();
        while (!cls.equals(CommonBehavior.class)) {
            for (Method method : cls.getDeclaredMethods()) {
                Typed typed = method.getAnnotation(Typed.class);
                if (typed == null) continue;
                Class paramType = Reflection.getParametrizedType(((Object)((Object)this)).getClass(), 0);
                if (method.getParameterCount() == 1 && (Behavior.class.isAssignableFrom(method.getReturnType()) || Void.TYPE.equals(method.getReturnType())) && !events.contains(method.getParameterTypes()[0])) {
                    events.add(method.getParameterTypes()[0]);
                    method.setAccessible(true);
                    boolean behavior = Behavior.class.isAssignableFrom(method.getReturnType());
                    boolean onMessage = paramType.isAssignableFrom(method.getParameterTypes()[0]);
                    if (onMessage) {
                        builder = builder.onMessage(method.getParameterTypes()[0], (Function & Serializable)m -> {
                            Object ret = method.invoke((Object)this, m);
                            return behavior ? (Behavior)ret : Behaviors.same();
                        });
                        continue;
                    }
                    builder = builder.onSignal(method.getParameterTypes()[0], (Function & Serializable)m -> {
                        Object ret = method.invoke((Object)this, m);
                        return behavior ? (Behavior)ret : Behaviors.same();
                    });
                    continue;
                }
                throw new SystemException("Invoiad method signature for method " + method);
            }
            cls = cls.getSuperclass();
        }
        receive = builder.build();
        cache.put(((Object)((Object)this)).getClass(), (Object)receive);
        return receive;
    }

    public akka.actor.typed.javadsl.ActorContext<T> getContext() {
        return this.context;
    }

    void setup(Guardian guardian, akka.actor.typed.javadsl.ActorContext<T> context) {
        this.guardian = guardian;
        this.context = context;
        this.initialize();
    }

    public ActorSystem<Void> getSystem() {
        return this.context.getSystem();
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public ActorRef<T> getSelf() {
        return this.getContext().getSelf();
    }

    protected void initialize() {
    }

    public <U> ActorRef<U> spawn(CommonBehavior<U> behavior, String name) {
        return this.context.spawn(Behaviors.setup((Function & Serializable)ctx -> {
            behavior.setup(this.guardian, (akka.actor.typed.javadsl.ActorContext)ctx);
            return behavior;
        }), name);
    }

    public <U> ActorRef<U> spawnAnonymous(CommonBehavior<U> behavior) {
        return this.context.spawnAnonymous(Behaviors.setup((Function & Serializable)ctx -> {
            behavior.setup(this.guardian, (akka.actor.typed.javadsl.ActorContext)ctx);
            return behavior;
        }));
    }

    public <U> ActorRef<U> spawnAnonymous(CommonBehavior<U> behavior, Props props) {
        return this.context.spawnAnonymous(Behaviors.setup((Function & Serializable)ctx -> {
            behavior.setup(this.guardian, (akka.actor.typed.javadsl.ActorContext)ctx);
            return behavior;
        }), props);
    }

    public <U> CompletionStage<U> ask(java.util.function.Function<ActorRef<U>, T> message, long timeoutMillis) {
        return AskPattern.ask((RecipientRef)this.context.getSelf(), (Function & Serializable)r -> message.apply((ActorRef)r), (Duration)Duration.ofMillis(timeoutMillis), (Scheduler)this.context.getSystem().scheduler());
    }

    public <U> void stop(ActorRef<U> child) {
        this.context.stop(child);
    }

    public void stop() {
        AskPattern.ask(this.getSelf(), (Function & Serializable)ref -> PoisonPill.getInstance(), (Duration)Duration.ofSeconds(10L), (Scheduler)this.context.getSystem().scheduler());
    }

    public akka.actor.ActorRef untypedRef() {
        return Adapter.toUntyped(this.getSelf());
    }

    public ActorContext untypedContext() {
        return Adapter.toUntyped(this.getContext());
    }

    public <T> akka.actor.ActorRef actorOf(akka.actor.Props props, String name) {
        return this.untypedContext().actorOf(props, name);
    }

    public <T> akka.actor.ActorRef actorOf(akka.actor.Props props) {
        return this.untypedContext().actorOf(props);
    }
}

