/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.SystemException;

public class PluginMap<K, V>
implements PluginFactory {
    private Map<K, Object> map = new LinkedHashMap<K, Object>();
    private PluginPath pluginPath;
    private PluginManager pluginManager;

    public PluginMap<K, V> create(PluginManager pluginManager) {
        PluginMap copy;
        try {
            copy = (PluginMap)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        copy.pluginManager = pluginManager;
        copy.map = this.map;
        return copy;
    }

    @Override
    public void initialize(PluginPath path) {
        this.pluginPath = path;
    }

    public void put(K key, V singleton) {
        this.map.put(key, singleton);
    }

    public void put(K key, Class<? extends V> cls) {
        this.map.put(key, cls);
    }

    public Object remove(K key) {
        return this.map.remove(key);
    }

    public Map<K, Object> plugins() {
        return this.map;
    }

    public Map<K, V> map() {
        return this.pluginManager.getResources().configurator().computeIfAbsent(this.pluginPath.path(), key -> {
            LinkedHashMap<K, Object> m = new LinkedHashMap<K, Object>();
            for (Map.Entry<K, Object> entry : this.map.entrySet()) {
                Object value;
                Object obj = entry.getValue();
                if (obj instanceof Class) {
                    value = this.pluginManager.createInstance(this.pluginPath, (Class)obj, new Object[0]);
                } else if (obj instanceof Plugin && ((Plugin)obj).isPrototype()) {
                    try {
                        Plugin plugin = (Plugin)obj.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Reflection.copyInstance(plugin, obj);
                        plugin.initialize(this.pluginPath);
                        this.pluginManager.inject(plugin, new Object[0]);
                        value = plugin;
                    }
                    catch (Exception e) {
                        throw new SystemException(e);
                    }
                } else {
                    value = obj;
                }
                m.put(entry.getKey(), value);
            }
            return m;
        });
    }
}

