/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Accessor;
import net.e6tech.elements.common.util.SystemException;

public class Accessors<T extends Accessor> {
    public static final Function<Field, Accessor> DEFAULT_FIELD_ACCESSOR_FACTORY = Accessor::new;
    public static final BiFunction<PropertyDescriptor, Accessor, Accessor> DEFAULT_PROPERTY_ACCESSOR_FACTORY = (desc, accessor) -> {
        if (desc.getName().equals("class")) {
            return null;
        }
        if (accessor != null) {
            return accessor.descriptor((PropertyDescriptor)desc);
        }
        return new Accessor((PropertyDescriptor)desc);
    };
    private Map<String, T> map = new HashMap<String, T>(100);

    public static Accessors<Accessor> simple(Class cls) {
        return new Accessors<Accessor>(cls, DEFAULT_FIELD_ACCESSOR_FACTORY, DEFAULT_PROPERTY_ACCESSOR_FACTORY);
    }

    public Accessors(Class targetClass, Function<Field, T> fieldFactory, BiFunction<PropertyDescriptor, T, T> descriptorFactory) {
        this.analyzeFields(targetClass, fieldFactory);
        this.analyzedDescriptors(targetClass, descriptorFactory);
    }

    private void analyzeFields(Class targetClass, Function<Field, T> fieldFactory) {
        if (fieldFactory != null) {
            for (Class cls = targetClass; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = cls.getDeclaredFields()) {
                    Accessor t;
                    if (Modifier.isStrict(field.getModifiers()) || (t = (Accessor)fieldFactory.apply(field)) == null || this.map.containsKey(t.getName())) continue;
                    this.map.put(t.getName(), t);
                }
            }
        }
    }

    private void analyzedDescriptors(Class targetClass, BiFunction<PropertyDescriptor, T, T> descriptorFactory) {
        if (descriptorFactory != null) {
            try {
                for (PropertyDescriptor desc : Introspector.getBeanInfo(targetClass).getPropertyDescriptors()) {
                    Accessor t = (Accessor)this.map.get(desc.getName());
                    String name = t == null ? null : t.getName();
                    if ((t = (Accessor)descriptorFactory.apply(desc, (PropertyDescriptor)((Object)t))) != null) {
                        this.map.put(t.getName(), t);
                        continue;
                    }
                    if (name == null) continue;
                    this.map.remove(name);
                }
            }
            catch (IntrospectionException e) {
                throw new SystemException(e);
            }
        }
    }

    public Map<String, T> getAccessors() {
        return this.map;
    }

    public Object get(Object target, String property) {
        Accessor t = (Accessor)this.map.get(property);
        if (t != null) {
            return t.get(target);
        }
        throw new IllegalArgumentException("Target class " + target.getClass() + " does not have a property named " + property);
    }

    public void set(Object target, String property, Object value) {
        Accessor t = (Accessor)this.map.get(property);
        if (t == null) {
            throw new IllegalArgumentException("Target class " + target.getClass() + " does not have a property named " + property);
        }
        t.set(target, value);
    }
}

