/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Lambda;
import net.e6tech.elements.common.util.SystemException;

public class Accessor {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private MethodHandle setter;
    private MethodHandle getter;
    private BiConsumer lambdaSetter;
    private Function lambdaGetter;
    private String name;
    private Class type;

    public Accessor(Field field) {
        this.field(field);
    }

    public Accessor(PropertyDescriptor descriptor) {
        this.descriptor(descriptor);
    }

    public static <A extends Annotation> A getAnnotation(PropertyDescriptor desc, AccessibleObject accessibleObject, Class<A> annotationClass) {
        A a = null;
        if (desc != null) {
            Method m = null;
            if (desc.getReadMethod() != null) {
                m = desc.getReadMethod();
            } else if (desc.getWriteMethod() != null) {
                m = desc.getWriteMethod();
            }
            if (m != null) {
                a = m.getAnnotation(annotationClass);
            }
        }
        if (a == null && accessibleObject != null) {
            a = accessibleObject.getAnnotation(annotationClass);
        }
        return a;
    }

    public static <A extends Annotation> A getAnnotation(PropertyDescriptor desc, Class<A> annotationClass) {
        return Accessor.getAnnotation(desc, null, annotationClass);
    }

    public static <A extends Annotation> A getAnnotation(AccessibleObject accessibleObject, Class<A> annotationClass) {
        return Accessor.getAnnotation(null, accessibleObject, annotationClass);
    }

    public static Map<Class<? extends Annotation>, Annotation> getAnnotations(PropertyDescriptor desc) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        Method m = null;
        if (desc.getReadMethod() != null) {
            m = desc.getReadMethod();
            for (Annotation a : m.getAnnotations()) {
                map.put(a.annotationType(), a);
            }
        }
        if (desc.getWriteMethod() != null) {
            m = desc.getWriteMethod();
            for (Annotation a : m.getAnnotations()) {
                map.put(a.annotationType(), a);
            }
        }
        return map;
    }

    public static Map<Class<? extends Annotation>, Annotation> getAnnotations(AccessibleObject accessibleObject) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation a : accessibleObject.getAnnotations()) {
            map.put(a.annotationType(), a);
        }
        return map;
    }

    public Accessor descriptor(PropertyDescriptor descriptor) {
        try {
            this.name = descriptor.getName();
            this.type = descriptor.getPropertyType();
            if (descriptor.getWriteMethod() != null) {
                this.setter = lookup.unreflect(descriptor.getWriteMethod());
                this.lambdaSetter = Lambda.reflectSetter(lookup, descriptor.getWriteMethod());
            }
        }
        catch (Exception ex) {
            throw new SystemException(ex);
        }
        try {
            if (descriptor.getReadMethod() != null) {
                this.getter = lookup.unreflect(descriptor.getReadMethod());
                this.lambdaGetter = Lambda.reflectGetter(lookup, descriptor.getReadMethod());
            }
        }
        catch (Exception ex) {
            throw new SystemException(ex);
        }
        return this;
    }

    public Accessor field(Field field) {
        if (this.setter != null) {
            return this;
        }
        this.name = field.getName();
        this.type = field.getType();
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            this.setter = lookup.unreflectSetter(field);
            this.getter = lookup.unreflectGetter(field);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Object get(Object target) {
        try {
            if (this.lambdaGetter != null) {
                return this.lambdaGetter.apply(target);
            }
            return this.getter.invoke(target);
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException());
        }
        catch (Throwable e) {
            throw new SystemException(e);
        }
    }

    public void set(Object target, Object value) {
        try {
            if (this.lambdaSetter != null) {
                this.lambdaSetter.accept(target, value);
            } else {
                this.setter.invoke(target, value);
            }
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException());
        }
        catch (Throwable e) {
            throw new SystemException(e);
        }
    }

    public Class getType() {
        return this.type;
    }
}

