/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.Props;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.japi.function.Function;
import java.io.Serializable;
import net.e6tech.elements.common.actor.typed.ExtensionEvents;
import net.e6tech.elements.common.actor.typed.Receptor;

public class Spawn<T, B extends Receptor<T, B>> {
    private String name;
    private Receptor<?, ?> parent;
    private Props props;

    public Spawn(Receptor<?, ?> parent) {
        this.parent = parent;
    }

    public Spawn<T, B> withProps(Props props) {
        this.props = props;
        return this;
    }

    public Spawn<T, B> withName(String name) {
        this.name = name;
        return this;
    }

    public B spawnNow(B common) {
        ActorRef<T> ref = this.spawn(common);
        ExtensionEvents.ExtensionsResponse extensions = (ExtensionEvents.ExtensionsResponse)this.parent.getGuardian().talk(ref, ExtensionEvents.class).askAndWait(ExtensionEvents.Extensions::new);
        return (B)extensions.getOwner();
    }

    public ActorRef<T> spawn(B common) {
        ActorContext<?> context = this.parent.getContext();
        if (this.name != null) {
            if (this.props != null) {
                return context.spawn(this.setup(common), this.name, this.props);
            }
            return context.spawn(this.setup(common), this.name);
        }
        if (this.props != null) {
            return context.spawnAnonymous(this.setup(common), this.props);
        }
        return context.spawnAnonymous(this.setup(common));
    }

    protected Behavior<T> setup(B common) {
        return Behaviors.setup((Function & Serializable)ctx -> common.setup(ctx, this.parent.getGuardian()));
    }
}

