/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.RecipientRef;
import akka.actor.typed.Scheduler;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.japi.function.Function;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.ExtensionEvents;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.WorkerPool;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class Guardian
extends Receptor<Void, Guardian> {
    private static final Logger logger = Logger.getLogger();
    private WorkerPool workerPool;
    private long timeout = 5000L;
    private String name = "galaxy";

    public static Guardian create(String name, long timeout, Config config, WorkerPoolConfig workerPoolConfig) {
        long start = System.currentTimeMillis();
        Behavior main = Behaviors.setup((Function & Serializable)context -> new Guardian().bootstrap((ActorContext<Void>)context, name, timeout, workerPoolConfig));
        ActorSystem sys = ActorSystem.create((Behavior)main, (String)name, (Config)config);
        try {
            ExtensionEvents.ExtensionsResponse extensions = Guardian.getExtensions((RecipientRef<ExtensionEvents>)sys, timeout, sys.scheduler());
            Guardian guardian = (Guardian)extensions.getOwner();
            logger.info("Staring Guardian in {}ms", System.currentTimeMillis() - start);
            return guardian;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private static ExtensionEvents.ExtensionsResponse getExtensions(RecipientRef<ExtensionEvents> recipient, long timeout, Scheduler scheduler) {
        CompletionStage stage = AskPattern.ask(recipient, ExtensionEvents.Extensions::new, (Duration)Duration.ofMillis(timeout), (Scheduler)scheduler);
        try {
            return (ExtensionEvents.ExtensionsResponse)stage.toCompletableFuture().get();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    protected Behavior<Void> bootstrap(ActorContext<Void> context, String name, long timeout, WorkerPoolConfig workerPoolConfig) {
        this.setName(name);
        this.setTimeout(timeout);
        this.setup(context, this);
        this.workerPool = this.childActor(WorkerPool.class).withName(workerPoolConfig.getName()).spawnNow(new WorkerPool(workerPoolConfig));
        return this.getBehavior();
    }

    public WorkerPool getWorkerPool() {
        return (WorkerPool)this.workerPool.virtualize();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompletionStage<Void> async(Runnable runnable, long timeout) {
        return this.workerPool.talk(timeout).ask(ref -> new WorkEvents.RunnableTask((ActorRef)ref, runnable));
    }

    public <R> CompletionStage<R> async(Callable<R> callable, long timeout) {
        return this.workerPool.talk(timeout).ask(ref -> new WorkEvents.CallableTask((ActorRef)ref, callable));
    }
}

