/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import net.e6tech.elements.common.launch.LaunchController;
import net.e6tech.elements.common.launch.LaunchListener;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;

public class Launch {
    private static final String LAUNCH = "launch";
    private static final String END = "end";
    List<LaunchController> controllers = new ArrayList<LaunchController>();

    public Launch(LaunchController ... controllers) {
        for (LaunchController controller : controllers) {
            this.controllers.add(controller);
        }
    }

    public static void main(String ... args) {
        ArrayList<LaunchController> controllers = new ArrayList<LaunchController>();
        Properties defaultProperties = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || i >= args.length - 1) continue;
            Object key = args[i];
            if (((String)key).startsWith("--")) {
                key = ((String)key).substring(2);
            } else if (((String)key).startsWith("-")) {
                key = ((String)key).substring(1);
            }
            if (args[i + 1].startsWith("-") || i + 1 >= args.length) continue;
            String val = args[++i];
            defaultProperties.put(key, val);
        }
        LaunchController controller = new LaunchController(defaultProperties);
        for (String arg : args) {
            if (arg.contains("=")) {
                String[] keyval = arg.split("=");
                controller.property(keyval[0], keyval[1]);
                continue;
            }
            if (arg.equalsIgnoreCase(END)) {
                controllers.add(controller);
                controller = new LaunchController(defaultProperties);
                continue;
            }
            controller.addArgument(arg);
        }
        if (!args[args.length - 1].equalsIgnoreCase(END)) {
            if (controller.getProperty(LAUNCH) != null) {
                controllers.add(controller);
            } else {
                List<String> arguments = controller.getArguments();
                for (LaunchController c : controllers) {
                    for (String arg : arguments) {
                        c.addArgument(arg);
                    }
                }
                Properties properties = controller.getProperties();
                for (String propKey : properties.stringPropertyNames()) {
                    for (LaunchController c : controllers) {
                        if (c.getProperty(propKey) != null) continue;
                        c.property(propKey, properties.getProperty(propKey));
                    }
                }
            }
        }
        Launch.launch(controllers);
    }

    private static void launch(List<LaunchController> controllerList) {
        LaunchController[] controllers = (LaunchController[])controllerList.stream().toArray(LaunchController[]::new);
        Launch launch = new Launch(controllers);
        launch.launch(new LaunchListener[0]);
    }

    public void launch(LaunchListener ... launchListeners) {
        ArrayList<LaunchListener> listeners = new ArrayList<LaunchListener>();
        if (launchListeners != null) {
            for (LaunchListener l : launchListeners) {
                listeners.add(l);
            }
        }
        CountDownLatch latch = new CountDownLatch(this.controllers.size());
        for (LaunchController controller : this.controllers) {
            controller.setLatch(latch);
            controller.launch(listeners);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SystemException(e);
        }
        for (LaunchController controller : this.controllers) {
            Provision provision = controller.getResourceManager().getInstance(Provision.class);
            controller.launched(provision);
            listeners.forEach(listener -> listener.launched(provision));
        }
    }
}

