/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.Scheduler;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.Props;
import akka.actor.typed.RecipientRef;
import akka.actor.typed.SpawnProtocol;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.japi.function.Function;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.WorkerPool;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.util.SystemException;

public class Guardian
extends CommonBehavior<Guardian, SpawnProtocol> {
    private ActorRef<WorkEvents> workerPool;
    private long timeout = 5000L;
    private String name = "galaxy";

    public Guardian boot(Config config, WorkerPoolConfig workerPoolConfig) {
        Behavior<WorkEvents> pool = WorkerPool.newPool(workerPoolConfig);
        Behavior main = Behaviors.setup((Function & Serializable)context -> {
            this.setup(this, context);
            return SpawnProtocol.behavior();
        });
        ActorSystem system = ActorSystem.create((Behavior)main, (String)this.name, (Config)config);
        try {
            CompletionStage stage = AskPattern.ask((RecipientRef)system, (Function & Serializable)replyTo -> new SpawnProtocol.Spawn(pool, workerPoolConfig.getName(), Props.empty(), replyTo), (Duration)Duration.ofSeconds(this.timeout), (Scheduler)system.scheduler());
            stage.whenComplete((ref, throwable) -> {
                this.workerPool = ref;
            });
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.async(runnable, this.timeout);
    }

    public CompletionStage<Void> async(Runnable runnable, long timeout) {
        return AskPattern.ask(this.workerPool, (Function & Serializable)ref -> new WorkEvents.RunnableTask((ActorRef)ref, runnable), (Duration)Duration.ofMillis(timeout), (Scheduler)this.getSystem().scheduler());
    }

    public <R> CompletionStage<R> async(Callable<R> callable) {
        return this.async(callable, this.timeout);
    }

    public <R> CompletionStage<R> async(Callable<R> callable, long timeout) {
        return AskPattern.ask(this.workerPool, (Function & Serializable)ref -> new WorkEvents.CallableTask((ActorRef)ref, callable), (Duration)Duration.ofMillis(timeout), (Scheduler)this.getSystem().scheduler());
    }
}

