/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.ActorContext;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Scheduler;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.RecipientRef;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.Adapter;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Spawn;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public abstract class CommonBehavior<S extends CommonBehavior, T>
extends AbstractBehavior<T> {
    private static Cache<Class, List<MessageBuilder>> cache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(500L).build();
    private akka.actor.typed.javadsl.ActorContext<T> context;
    private Guardian guardian;

    public Receive<T> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        Class<?> cls = ((Object)((Object)this)).getClass();
        HashSet<String> events = new HashSet<String>();
        while (!cls.equals(CommonBehavior.class)) {
            builder = this.build(builder, cls, events);
            cls = cls.getSuperclass();
        }
        Receive receive = builder.build();
        return receive;
    }

    private ReceiveBuilder build(ReceiveBuilder builder, Class cls, Set<String> events) {
        ArrayList<MessageBuilder> list = (ArrayList<MessageBuilder>)cache.getIfPresent((Object)cls);
        if (list == null) {
            list = new ArrayList<MessageBuilder>();
            for (Method method : cls.getDeclaredMethods()) {
                Typed typed = method.getAnnotation(Typed.class);
                if (typed == null) continue;
                Class paramType = Reflection.getParametrizedType(((Object)((Object)this)).getClass(), 1);
                if (method.getParameterCount() == 1 && (Behavior.class.isAssignableFrom(method.getReturnType()) || Void.TYPE.equals(method.getReturnType()))) {
                    method.setAccessible(true);
                    boolean behavior = Behavior.class.isAssignableFrom(method.getReturnType());
                    boolean onMessage = paramType.isAssignableFrom(method.getParameterTypes()[0]);
                    if (onMessage) {
                        list.add(new OnMessage(method, behavior));
                        continue;
                    }
                    list.add(new OnSignal(method, behavior));
                    continue;
                }
                throw new SystemException("Invalid method signature for method " + method);
            }
            cache.put((Object)cls, list);
        }
        for (MessageBuilder mb : list) {
            if (events.contains(mb.signature())) continue;
            events.add(mb.signature());
            builder = mb.build(builder, (Behavior)this);
        }
        return builder;
    }

    public akka.actor.typed.javadsl.ActorContext<T> getContext() {
        return this.context;
    }

    public void setup(Guardian guardian, akka.actor.typed.javadsl.ActorContext<T> context) {
        this.guardian = guardian;
        this.context = context;
        this.initialize();
    }

    public ActorSystem<Void> getSystem() {
        return this.context.getSystem();
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public ActorRef<T> getSelf() {
        return this.getContext().getSelf();
    }

    protected void initialize() {
    }

    public <X extends CommonBehavior<X, Y>, Y> Spawn<X, Y> childActor(X child) {
        return new Spawn(this, child);
    }

    public <U> CompletionStage<U> ask(java.util.function.Function<ActorRef<U>, T> message, long timeoutMillis) {
        return AskPattern.ask((RecipientRef)this.context.getSelf(), message::apply, (Duration)Duration.ofMillis(timeoutMillis), (Scheduler)this.context.getSystem().scheduler());
    }

    public S tell(T msg) {
        this.context.getSelf().tell(msg);
        return (S)((Object)this);
    }

    public <U> void stop(ActorRef<U> child) {
        this.context.stop(child);
    }

    public void stop() {
        AskPattern.ask(this.getSelf(), (Function & Serializable)ref -> PoisonPill.getInstance(), (Duration)Duration.ofSeconds(10L), (Scheduler)this.context.getSystem().scheduler());
    }

    public akka.actor.ActorRef untypedRef() {
        return Adapter.toUntyped(this.getSelf());
    }

    public ActorContext untypedContext() {
        return Adapter.toUntyped(this.getContext());
    }

    public akka.actor.ActorRef actorOf(Props props, String name) {
        return this.untypedContext().actorOf(props, name);
    }

    public akka.actor.ActorRef actorOf(Props props) {
        return this.untypedContext().actorOf(props);
    }

    static class OnSignal
    extends MessageBuilder {
        OnSignal(Method method, boolean behavior) {
            super(method, behavior);
        }

        @Override
        public ReceiveBuilder build(ReceiveBuilder builder, Behavior target) {
            return builder.onSignal(this.method.getParameterTypes()[0], (Function & Serializable)m -> {
                Object ret = this.method.invoke((Object)target, m);
                return this.behavior ? (Behavior)ret : Behaviors.same();
            });
        }
    }

    static class OnMessage
    extends MessageBuilder {
        OnMessage(Method method, boolean behavior) {
            super(method, behavior);
        }

        @Override
        public ReceiveBuilder build(ReceiveBuilder builder, Behavior target) {
            return builder.onMessage(this.method.getParameterTypes()[0], (Function & Serializable)m -> {
                Object ret = this.method.invoke((Object)target, m);
                return this.behavior ? (Behavior)ret : Behaviors.same();
            });
        }
    }

    static abstract class MessageBuilder {
        protected boolean behavior;
        protected Method method;
        private String signature;

        MessageBuilder(Method method, boolean behavior) {
            this.method = method;
            this.behavior = behavior;
            StringBuilder builder = new StringBuilder();
            builder.append(method.getName());
            builder.append("(");
            boolean first = true;
            for (Class<?> param : method.getParameterTypes()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(param.getTypeName());
            }
            builder.append(")");
            this.signature = builder.toString();
        }

        abstract ReceiveBuilder build(ReceiveBuilder var1, Behavior var2);

        String signature() {
            return this.signature;
        }
    }
}

