/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.util.SystemException;

public class Annotator
implements InvocationHandler {
    static Map<String, Integer> objectMethods = new HashMap<String, Integer>();
    private Map<Method, Object> values;
    private Method lastAccessed;
    private Class<? extends Annotation> type;
    private Integer hashCode;
    private String toString;

    protected Annotator(Class type, Map<Method, Object> values) {
        this.type = type;
        this.values = values;
    }

    public static <T extends Annotation> T create(Class<? extends Annotation> cls, BiConsumer<AnnotationValue, T> consumer) {
        return Annotator.create(cls, null, consumer);
    }

    public static <T extends Annotation> T create(Class<? extends Annotation> cls, T original, BiConsumer<AnnotationValue, T> consumer) {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : cls.getDeclaredMethods()) {
            if (objectMethods.containsKey(method.getName()) && method.getParameterCount() == objectMethods.get(method.getName()).intValue()) continue;
            Object defaultValue = method.getDefaultValue();
            values.put(method, defaultValue);
        }
        Annotator annotator = new Annotator(cls, values);
        annotator.copyFrom(original);
        AnnotationValue annotationValue = new AnnotationValue(annotator);
        if (consumer != null) {
            consumer.accept(annotationValue, (AnnotationValue)((Object)((Annotation)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)annotator))));
        }
        return (T)((Annotation)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)annotator));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("hashCode".equals(methodName) && method.getParameterCount() == 0) {
            if (this.hashCode == null) {
                this.hashCode = this.hashCodeImpl();
            }
            return this.hashCode;
        }
        if ("equals".equals(methodName) && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object.class)) {
            return this.equalsImpl(args[0]);
        }
        if ("annotationType".equals(methodName) && method.getParameterCount() == 0) {
            return this.type;
        }
        if ("toString".equals(methodName) && method.getParameterCount() == 0) {
            if (this.toString == null) {
                this.toString = this.toStringImpl();
            }
            return this.toString;
        }
        this.lastAccessed = method;
        Object value = this.values.get(method);
        if (value == null && method.getReturnType().isPrimitive()) {
            return Primitives.defaultValue(method.getReturnType());
        }
        return value;
    }

    private <T extends Annotation> void copyFrom(T original) {
        if (original == null) {
            return;
        }
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            try {
                entry.setValue(entry.getKey().invoke(original, new Object[0]));
            }
            catch (Exception e) {
                Logger.suppress(e);
            }
        }
        this.hashCode = null;
        this.toString = null;
    }

    private int hashCodeImpl() {
        int hash = 0;
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            hash += 127 * entry.getKey().getName().hashCode() ^ Primitives.hashCode(entry.getValue());
        }
        return hash;
    }

    private boolean equalsImpl(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!this.type.isInstance(object)) {
            return false;
        }
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            try {
                Object value2 = entry.getKey().invoke(object, new Object[0]);
                if (Primitives.equals(entry.getValue(), value2)) continue;
                return false;
            }
            catch (Exception e) {
                Logger.suppress(e);
                return false;
            }
        }
        return true;
    }

    private String toStringImpl() {
        StringBuilder builder = new StringBuilder(128);
        builder.append('@');
        builder.append(this.type.getName());
        builder.append('(');
        boolean first = true;
        for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(entry.getKey().getName());
            builder.append('=');
            builder.append(Primitives.toString(entry.getValue()));
        }
        builder.append(')');
        return builder.toString();
    }

    static {
        objectMethods.put("toString", 0);
        objectMethods.put("hashCode", 0);
        objectMethods.put("annotationType", 0);
        objectMethods.put("equals", 1);
    }

    public static class AnnotationValue {
        private Annotator handler;

        public AnnotationValue(Annotator handler) {
            this.handler = handler;
        }

        public <T> AnnotationValue set(Callable<T> callable, T value) {
            return this._set(callable, value);
        }

        private <K> AnnotationValue _set(Callable<K> callable, K value) {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            this.handler.values.put(this.handler.lastAccessed, value);
            this.handler.hashCode = null;
            this.handler.toString = null;
            this.handler.lastAccessed = null;
            return this;
        }
    }
}

