/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed.worker;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.japi.function.Function;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.Worker;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.reflection.Reflection;

public class WorkerPool
extends CommonBehavior<WorkerPool, WorkEvents> {
    private boolean cleanupScheduled = false;
    private Set<ActorRef<WorkEvents>> workers = new LinkedHashSet<ActorRef<WorkEvents>>();
    private Set<ActorRef<WorkEvents>> idleWorkers = new LinkedHashSet<ActorRef<WorkEvents>>();
    private LinkedList<Task> waiting = new LinkedList();
    private WorkerPoolConfig config = new WorkerPoolConfig();
    private ActorContext<WorkEvents> context;

    public static Behavior<WorkEvents> newPool(WorkerPoolConfig config) {
        return Behaviors.setup((Function & Serializable)ctx -> {
            WorkerPool instance = new WorkerPool((ActorContext<WorkEvents>)ctx);
            Reflection.copyInstance(instance.config, config);
            for (int i = 0; i < instance.config.getInitialCapacity(); ++i) {
                instance.newWorker();
            }
            return instance;
        });
    }

    public WorkerPool(ActorContext<WorkEvents> context) {
        this.context = context;
    }

    @Typed
    private Behavior<WorkEvents> terminated(Terminated event) {
        this.workers.remove(event.ref());
        this.idleWorkers.remove(event.ref());
        return Behaviors.same();
    }

    @Typed
    private void newRunnable(WorkEvents.RunnableTask event) {
        if (!this.idleWorkers.isEmpty()) {
            Iterator<ActorRef<WorkEvents>> iterator = this.idleWorkers.iterator();
            ActorRef<WorkEvents> worker = iterator.next();
            iterator.remove();
            worker.tell((Object)event);
        } else if (this.workers.size() < this.config.getMaxCapacity()) {
            this.waiting.add(new Task(event.getSender(), event));
            this.newWorker();
        } else {
            this.waiting.add(new Task(event.getSender(), event));
        }
    }

    @Typed
    private void newCallable(WorkEvents.CallableTask event) {
        if (!this.idleWorkers.isEmpty()) {
            Iterator<ActorRef<WorkEvents>> iterator = this.idleWorkers.iterator();
            ActorRef<WorkEvents> worker = iterator.next();
            iterator.remove();
            worker.tell((Object)event);
        } else if (this.workers.size() < this.config.getMaxCapacity()) {
            this.waiting.add(new Task(event.getSender(), event));
            this.newWorker();
        } else {
            this.waiting.add(new Task(event.getSender(), event));
        }
    }

    private void newWorker() {
        ActorRef worker = this.context.spawnAnonymous(Behaviors.setup((Function & Serializable)ctx -> new Worker((ActorContext)ctx, this.context.getSelf())));
        this.workers.add((ActorRef<WorkEvents>)worker);
        this.context.watch(worker);
        this.idle(worker);
    }

    @Typed
    private void idle(WorkEvents.IdleWorker event) {
        this.idle(event.getWorker());
    }

    private void idle(ActorRef worker) {
        if (!this.waiting.isEmpty()) {
            Task task = this.waiting.removeFirst();
            worker.tell(task.getWork());
        } else {
            this.idleWorkers.add((ActorRef<WorkEvents>)worker);
            this.cleanup(new WorkEvents.Cleanup());
        }
    }

    @Typed
    private void cleanup(WorkEvents.Cleanup message) {
        if (this.cleanupScheduled) {
            return;
        }
        if (this.config.getIdleTimeout() == 0L) {
            return;
        }
        Duration interval = Duration.ofMillis(this.config.getIdleTimeout());
        ActorRef self = this.context.getSelf();
        this.context.scheduleOnce(interval, self, (Object)new WorkEvents.Cleanup());
        this.cleanupScheduled = true;
    }

    private class Task {
        ActorRef sender;
        Object work;

        public Task(ActorRef sender, Object work) {
            this.sender = sender;
            this.work = work;
        }

        public ActorRef getSender() {
            return this.sender;
        }

        public Object getWork() {
            return this.work;
        }
    }
}

