/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.Props;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.japi.function.Function;
import java.io.Serializable;
import java.util.function.BiConsumer;
import net.e6tech.elements.common.actor.typed.CommonBehavior;

public class Spawn<S extends CommonBehavior<S, T>, T> {
    private String name;
    private CommonBehavior parent;
    private S behavior;
    private Props props;
    private BiConsumer<ActorContext<T>, S> setup;

    public Spawn(CommonBehavior parent, S behavior) {
        this.parent = parent;
        this.behavior = behavior;
    }

    public Spawn<S, T> withProps(Props props) {
        this.props = props;
        return this;
    }

    public Spawn<S, T> withName(String name) {
        this.name = name;
        return this;
    }

    public Spawn<S, T> whenSetup(BiConsumer<ActorContext<T>, S> consumer) {
        this.setup = consumer;
        return this;
    }

    public ActorRef<T> spawn() {
        ActorContext context = this.parent.getContext();
        if (this.name != null) {
            if (this.props != null) {
                return context.spawn(this.setup(), this.name, this.props);
            }
            return context.spawn(this.setup(), this.name);
        }
        if (this.props != null) {
            return context.spawnAnonymous(this.setup(), this.props);
        }
        return context.spawnAnonymous(this.setup());
    }

    Behavior<T> setup() {
        return Behaviors.setup((Function & Serializable)ctx -> {
            ((CommonBehavior)((Object)((Object)((Object)this.behavior)))).setup(this.parent.getGuardian(), ctx);
            if (this.setup != null) {
                this.setup.accept((ActorContext<ActorContext>)ctx, this.behavior);
            }
            return this.behavior;
        });
    }
}

