/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.ActorContext;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Scheduler;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.RecipientRef;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.Adapter;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Spawn;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public abstract class CommonBehavior<S extends CommonBehavior, T>
extends AbstractBehavior<T> {
    private akka.actor.typed.javadsl.ActorContext<T> context;
    private Guardian guardian;

    public Receive<T> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        Class<?> cls = ((Object)((Object)this)).getClass();
        HashSet<Class> events = new HashSet<Class>();
        while (!cls.equals(CommonBehavior.class)) {
            builder = this.build(builder, cls, events);
            cls = cls.getSuperclass();
        }
        Receive receive = builder.build();
        return receive;
    }

    private ReceiveBuilder build(ReceiveBuilder builder, Class cls, Set<Class> events) {
        for (Method method : cls.getDeclaredMethods()) {
            Typed typed = method.getAnnotation(Typed.class);
            if (typed == null) continue;
            Class paramType = Reflection.getParametrizedType(((Object)((Object)this)).getClass(), 1);
            if (method.getParameterCount() == 1 && (Behavior.class.isAssignableFrom(method.getReturnType()) || Void.TYPE.equals(method.getReturnType())) && !events.contains(method.getParameterTypes()[0])) {
                events.add(method.getParameterTypes()[0]);
                method.setAccessible(true);
                boolean behavior = Behavior.class.isAssignableFrom(method.getReturnType());
                boolean onMessage = paramType.isAssignableFrom(method.getParameterTypes()[0]);
                if (onMessage) {
                    builder = builder.onMessage(method.getParameterTypes()[0], (Function & Serializable)m -> {
                        Object ret = method.invoke((Object)this, m);
                        return behavior ? (Behavior)ret : Behaviors.same();
                    });
                    continue;
                }
                builder = builder.onSignal(method.getParameterTypes()[0], (Function & Serializable)m -> {
                    Object ret = method.invoke((Object)this, m);
                    return behavior ? (Behavior)ret : Behaviors.same();
                });
                continue;
            }
            throw new SystemException("Invoiad method signature for method " + method);
        }
        return builder;
    }

    public akka.actor.typed.javadsl.ActorContext<T> getContext() {
        return this.context;
    }

    public void setup(Guardian guardian, akka.actor.typed.javadsl.ActorContext<T> context) {
        this.guardian = guardian;
        this.context = context;
        this.initialize();
    }

    public ActorSystem<Void> getSystem() {
        return this.context.getSystem();
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public ActorRef<T> getSelf() {
        return this.getContext().getSelf();
    }

    protected void initialize() {
    }

    public <X extends CommonBehavior<X, Y>, Y> Spawn<X, Y> childActor(X child) {
        return new Spawn(this, child);
    }

    public <U> CompletionStage<U> ask(java.util.function.Function<ActorRef<U>, T> message, long timeoutMillis) {
        return AskPattern.ask((RecipientRef)this.context.getSelf(), message::apply, (Duration)Duration.ofMillis(timeoutMillis), (Scheduler)this.context.getSystem().scheduler());
    }

    public S tell(T msg) {
        this.context.getSelf().tell(msg);
        return (S)((Object)this);
    }

    public <U> void stop(ActorRef<U> child) {
        this.context.stop(child);
    }

    public void stop() {
        AskPattern.ask(this.getSelf(), (Function & Serializable)ref -> PoisonPill.getInstance(), (Duration)Duration.ofSeconds(10L), (Scheduler)this.context.getSystem().scheduler());
    }

    public akka.actor.ActorRef untypedRef() {
        return Adapter.toUntyped(this.getSelf());
    }

    public ActorContext untypedContext() {
        return Adapter.toUntyped(this.getContext());
    }

    public akka.actor.ActorRef actorOf(Props props, String name) {
        return this.untypedContext().actorOf(props, name);
    }

    public akka.actor.ActorRef actorOf(Props props) {
        return this.untypedContext().actorOf(props);
    }
}

