/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;

public class Genesis
implements Initializable {
    public static final String WORKER_POOL_DISPATCHER = "worker-pool-dispatcher";
    private String name;
    private String configuration;
    private Guardian guardian;
    private WorkerPoolConfig workPoolConfig = new WorkerPoolConfig();
    private long timeout = 5000L;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public WorkerPoolConfig getWorkPoolConfig() {
        return this.workPoolConfig;
    }

    public void setWorkPoolConfig(WorkerPoolConfig workPoolConfig) {
        this.workPoolConfig = workPoolConfig;
    }

    @Override
    public void initialize(Resources resources) {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        Config config = null;
        config = this.configuration != null ? ConfigFactory.parseString((String)this.configuration) : ConfigFactory.defaultApplication();
        this.initialize(config);
        if (resources != null) {
            ResourceManager resourceManager = resources.getResourceManager();
            resourceManager.addResourceProvider(ResourceProvider.wrap("Genesis", this::shutdown));
        }
    }

    public void initialize(Config cfg) {
        Config config;
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        Config config2 = config = cfg != null ? cfg : ConfigFactory.defaultApplication();
        if (!config.hasPath(WORKER_POOL_DISPATCHER)) {
            config = config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)"worker-pool-dispatcher {\n  type = Dispatcher\n  thread-pool-executor {\n      keep-alive-time = 60s\n      core-pool-size-min = 8\n      core-pool-size-factor = 5.0\n      # unbounded so that max-pool-size-factor has no effect.\n      task-queue-size = -1\n      allow-core-timeout = on\n    }\n  throughput = 1\n}"));
        }
        this.guardian = new Guardian();
        this.guardian.setName(this.getName());
        this.guardian.setTimeout(this.getTimeout());
        this.guardian.boot(config, this.workPoolConfig);
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public void shutdown() {
        this.guardian.getSystem().terminate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void terminate() {
        this.guardian.getSystem().terminate();
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.async(runnable, this.getTimeout());
    }

    public CompletionStage<Void> async(Runnable runnable, long timeout) {
        return this.guardian.async(runnable, timeout);
    }

    public <R> CompletionStage<R> async(Callable<R> callable) {
        return this.async(callable, this.getTimeout());
    }

    public <R> CompletionStage<R> async(Callable<R> callable, long timeout) {
        return this.guardian.async(callable, timeout);
    }
}

