/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.Optional;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.DefaultPluginModel;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.util.SystemException;

public interface PluginModel {
    public Resources getResources();

    public String getName();

    default public <P extends Plugin> void registerPlugin(Class<P> pluginBaseClass, P plugin) {
        this.getResources().getResourceManager().getPluginManager().add(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> void registerPlugin(Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        this.getResources().getResourceManager().getPluginManager().add(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> P unregisterPlugin(Class<P> pluginBaseClass) {
        return (P)((Plugin)this.getResources().getResourceManager().getPluginManager().remove(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass)));
    }

    default public <P extends Plugin> void registerPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass, P plugin) {
        this.getResources().getResourceManager().getPluginManager().add(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), plugin);
    }

    default public <P extends Plugin> void registerPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass, Class<? extends P> pluginClass) {
        this.getResources().getResourceManager().getPluginManager().add(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), pluginClass);
    }

    default public <P extends Plugin> P unregisterPlugin(Class pathClass, String pathAttribute, Class<P> pluginBaseClass) {
        return (P)((Plugin)this.getResources().getResourceManager().getPluginManager().remove(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass)));
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> boolean isPluginRegistered(Class pathClass, String pathAttribute, Class<P> pluginBaseClass) {
        return this.getResources().getPlugin(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(pluginBaseClass), new Object[0]).isPresent();
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class<P> cls) {
        return PluginPaths.of(this.getClass(), this.getName(), cls);
    }

    default public <P extends Plugin> PluginPaths<P> getPluginPaths(Class pathClass, String pathAttribute, Class<P> cls) {
        return PluginPaths.of(PluginPath.of(this.getClass(), this.getName()).and(pathClass, pathAttribute).and(cls));
    }

    default public <P extends Plugin> Optional<P> getPlugin(Class<P> cls, Object ... args) {
        Optional<P> optional = this.getResources().getPlugin(this.getPluginPaths(cls), args);
        if (optional.isPresent()) {
            return optional;
        }
        return DefaultPluginModel.from(this.getResources()).getPlugin(cls, args);
    }

    default public <P extends Plugin> Optional<P> getLevel2Plugin(Class pathClass, String pathAttribute, Class<P> cls, Object ... args) {
        return this.getResources().getPlugin(this.getPluginPaths(pathClass, pathAttribute, cls), args);
    }

    default public <P extends Plugin> P newPlugin(Class<P> cls, Object ... args) {
        try {
            return (P)((Plugin)this.getPlugin(cls, args).orElse(cls.newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SystemException(e);
        }
    }

    default public Optional<PluginModel> parent() {
        return Optional.empty();
    }
}

