/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import java.nio.file.Path;
import java.nio.file.Paths;

public class ScriptPath {
    private boolean classPath;
    private String fileName;

    public ScriptPath(String path) {
        this.fileName = path;
        if (this.fileName.startsWith("classpath://")) {
            this.fileName = this.fileName.substring("classpath://".length());
            this.classPath = true;
        } else if (this.fileName.startsWith("classpath:/")) {
            this.fileName = this.fileName.substring("classpath:/".length());
            this.classPath = true;
        } else if (this.fileName.startsWith("classpath:")) {
            this.fileName = this.fileName.substring("classpath:".length());
            this.classPath = true;
        }
    }

    public String getParent() {
        String parent = Paths.get(this.fileName, new String[0]).getParent().toString();
        if (this.classPath) {
            return "classpath://" + parent;
        }
        return parent;
    }

    public boolean isClassPath() {
        return this.classPath;
    }

    public void setClassPath(boolean classPath) {
        this.classPath = classPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getClassPath() {
        return "classpath://" + this.getFileName();
    }

    public Path getPath() {
        return Paths.get(this.fileName, new String[0]);
    }
}

