/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.util.Expando;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.BootstrapBeginEnv;
import net.e6tech.elements.common.resources.BootstrapEndEnv;
import net.e6tech.elements.common.resources.BootstrapListener;
import net.e6tech.elements.common.resources.BootstrapSystemPropertiesListener;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.Terminal;
import net.e6tech.elements.common.util.concurrent.ThreadPool;
import org.apache.logging.log4j.ThreadContext;

public class Bootstrap
extends GroovyObjectSupport {
    private static final String LINE_SEPARATOR = "***********************************************************";
    private static Logger logger = Logger.getLogger();
    private static final String PRE_BOOT = "preBoot";
    private static final String POST_BOOT = "postBoot";
    private static final String BOOT_ENV = "bootEnv";
    private static final String BOOT_AFTER = "bootAfter";
    private static final String BOOT_DISABLE_LIST = "bootDisableList";
    private static final String PLUGIN_DIRECTORIES = "pluginDirectories";
    private static final String PROVISION_CLASS = "provisionClass";
    private static final String HOST_ENVIRONMENT_FILE = "hostEnvironmentFile";
    private static final String HOST_SYSTEM_PROPERTIES_FILE = "hostSystemPropertiesFile";
    private static final String ENVIRONMENT = "environment";
    private static final String SYSTEM_PROPERTIES = "systemProperties";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String bootstrapDir = ".";
    private String defaultEnvironmentFile;
    private String defaultSystemProperties;
    private int bootIndex = 0;
    private List initBoot = new ArrayList();
    private Map preBoot = new LinkedHashMap();
    private Map main = new LinkedHashMap();
    private Map postBoot = new LinkedHashMap();
    private Map after = new LinkedHashMap();
    private ResourceManager resourceManager;
    private MyExpando expando = new MyExpando();
    private Set<String> disableList = new LinkedHashSet<String>();
    private Set bootComponents = new HashSet();
    private boolean bootEnv = false;
    private boolean bootProvision = false;
    private boolean bootInit = false;
    private List<BootstrapListener> listeners = new ArrayList<BootstrapListener>();

    public Bootstrap(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Map getMain() {
        return this.main;
    }

    public void setMain(Map main) {
        this.main = main;
        main.keySet().forEach(key -> this.setComponent(key, false));
    }

    public String getDir() {
        return this.bootstrapDir;
    }

    public void setDir(String dir) {
        this.bootstrapDir = dir;
    }

    public String getDefaultEnvironmentFile() {
        return this.defaultEnvironmentFile;
    }

    public void setDefaultEnvironmentFile(String defaultEnvironmentFile) {
        this.defaultEnvironmentFile = defaultEnvironmentFile;
    }

    public String getDefaultSystemProperties() {
        return this.defaultSystemProperties;
    }

    public void setDefaultSystemProperties(String defaultSystemProperties) {
        this.defaultSystemProperties = defaultSystemProperties;
    }

    public List<String> getInitBoot() {
        return this.initBoot;
    }

    public void setInitBoot(List initBoot) {
        this.initBoot = initBoot;
    }

    public Bootstrap initBoot(List initBoot) {
        if (this.initBoot == null) {
            this.initBoot = initBoot;
        } else {
            this.initBoot.addAll(initBoot);
        }
        return this;
    }

    public List<String> getInit() {
        return this.getInitBoot();
    }

    public void setInit(List initBoot) {
        this.setInitBoot(initBoot);
    }

    public Map getAfter() {
        return this.after;
    }

    public void setAfter(Map after) {
        this.after = after;
        after.keySet().forEach(key -> this.setComponent(key, false));
    }

    public List<ComponentInfo> componentInfos() {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        this.preBoot.forEach((key, value) -> list.add(this.componentInfo(PRE_BOOT, key, value)));
        this.main.forEach((key, value) -> list.add(this.componentInfo("main", key, value)));
        this.postBoot.forEach((key, value) -> list.add(this.componentInfo(POST_BOOT, key, value)));
        this.after.forEach((key, value) -> list.add(this.componentInfo(BOOT_AFTER, key, value)));
        return list;
    }

    private ComponentInfo componentInfo(String stage, Object key, Object value) {
        ComponentInfo info = new ComponentInfo();
        info.stage = stage;
        if (key instanceof Closure) {
            info.name = value.toString();
            Closure closure = (Closure)key;
            if (closure.isCase((Object)EMPTY_OBJECT_ARRAY)) {
                info.enabled = true;
            } else {
                info.enabled = false;
            }
        } else {
            info.name = key.toString();
            Object on = this.expando.getProperty(key.toString());
            if (Boolean.TRUE.equals(on)) {
                info.enabled = true;
            } else {
                info.enabled = false;
            }
        }
        return info;
    }

    public void addBootstrapListener(BootstrapListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeBootstrapListener(BootstrapListener listener) {
        return this.listeners.remove(listener);
    }

    public void addBootstrapBeginEnv(BootstrapBeginEnv listener) {
        this.listeners.add(listener);
    }

    public void addBootstrapEndEnv(BootstrapEndEnv listener) {
        this.listeners.add(listener);
    }

    public void addBootstrapSystemPropertiesListener(BootstrapSystemPropertiesListener listener) {
        this.listeners.add(listener);
    }

    public Map getBootEnv() {
        Object bootEnvOverride = this.getVar(BOOT_ENV);
        if (bootEnvOverride instanceof Map) {
            return (Map)bootEnvOverride;
        }
        return null;
    }

    public void setBootEnv(Map map) {
        if (map == null) {
            return;
        }
        Map override = this.getBootEnv();
        if (override != null) {
            override.putAll(map);
        } else {
            override = map;
            this.resourceManager.getScripting().put(BOOT_ENV, override);
        }
    }

    private void setComponent(Object key, boolean on) {
        if (key instanceof Closure) {
            Closure closure = (Closure)key;
            closure.setDelegate((Object)this.expando);
            closure.setResolveStrategy(1);
        } else {
            String propertyName = key.toString();
            this.expando.setProperty(propertyName, on);
        }
    }

    private void bootMessage(String message) {
        String line = LINE_SEPARATOR;
        if (logger.isInfoEnabled()) {
            logger.info(line);
            logger.info(message);
            logger.info(line);
        }
    }

    public Bootstrap enable(String ... components) {
        if (components != null) {
            for (String component : components) {
                this.disableList.remove(component);
                this.expando.setProperty(component, true);
            }
        }
        return this;
    }

    public Bootstrap disable(String ... components) {
        if (components != null) {
            for (String component : components) {
                this.disableList.add(component);
                this.expando.setProperty(component, false);
            }
        }
        return this;
    }

    public void setPreBoot(Object pre) {
        this.setupBootList(pre, this.preBoot);
    }

    public Bootstrap preBoot(Object pre) {
        this.setupBootList(pre, this.preBoot);
        return this;
    }

    public void setPostBoot(Object post) {
        this.setupBootList(post, this.postBoot);
    }

    public Bootstrap postBoot(Object post) {
        this.setupBootList(post, this.postBoot);
        return this;
    }

    public Bootstrap boot(Object bootScript, Object ... components) {
        if (bootScript != null) {
            this.exec(bootScript);
        }
        if (this.main.isEmpty() && this.after.isEmpty()) {
            logger.warn("Components not configured.  Use main or after to configure components.");
        }
        this.bootEnvironment();
        this.bootProvision();
        this.bootInitialContext();
        if (components != null) {
            for (Object component : components) {
                if (!(component instanceof Map)) continue;
                Map map = (Map)component;
                map.forEach((key, value) -> {
                    this.after.put(key, value);
                    this.setComponent(key, true);
                });
            }
        }
        if (components != null) {
            for (Object component : components) {
                if (component instanceof Map) continue;
                if (this.after.get(component) == null && this.main.get(component) == null) {
                    this.main.put(component, this.bootstrapDir + File.separator + component);
                }
                this.expando.setProperty(component.toString(), true);
            }
        }
        if (this.disableList != null) {
            for (String component : this.disableList) {
                this.expando.setProperty(component, false);
            }
        }
        this.listeners.forEach(l -> l.beginBoot(this));
        if (this.initBoot != null && !this.initBoot.isEmpty()) {
            this.initBoot();
        }
        if (this.preBoot != null && !this.preBoot.isEmpty()) {
            this.preBoot();
        }
        if (this.main != null && !this.main.isEmpty()) {
            this.bootMain();
        }
        if (this.postBoot != null && !this.postBoot.isEmpty()) {
            this.postBoot();
        }
        if (this.after != null && !this.after.isEmpty()) {
            this.bootAfter();
        }
        this.listeners.forEach(l -> l.endBoot(this));
        this.bootMessage("Booting completed");
        return this;
    }

    private void bootEnvironment() {
        Object p;
        if (this.bootEnv) {
            return;
        }
        this.bootMessage("Loading environment");
        this.listeners.forEach(l -> l.beginEnv(this));
        if (this.defaultEnvironmentFile != null) {
            this.exec(this.defaultEnvironmentFile);
        } else {
            String script = this.getVar("__dir") + "/environment.groovy";
            File file = new File(script);
            if (file.exists()) {
                this.exec(script);
            } else {
                logger.warn("!! No default environment script.");
            }
        }
        String envFile = this.getVar("__load_dir") + "/environment.groovy";
        if (this.getVar(ENVIRONMENT) != null) {
            envFile = this.getVar(ENVIRONMENT).toString();
        }
        this.tryExec(envFile);
        Object bootEnvOverride = this.getVar(BOOT_ENV);
        if (bootEnvOverride instanceof Map) {
            Map map = (Map)bootEnvOverride;
            map.forEach((key, val) -> this.resourceManager.getScripting().put((String)key, val));
        }
        if (this.getVar(HOST_ENVIRONMENT_FILE) != null) {
            envFile = this.getVar(HOST_ENVIRONMENT_FILE).toString();
            this.tryExec(envFile);
        }
        this.listeners.forEach(l -> l.beginSystemProperties(this));
        if (this.defaultSystemProperties != null) {
            this.exec(this.defaultSystemProperties);
        } else {
            String script = this.getVar("__dir") + "/system_properties.groovy";
            this.tryExec(script);
        }
        String sysFile = this.getVar("__load_dir") + "/system_properties.groovy";
        if (this.getVar(SYSTEM_PROPERTIES) != null) {
            sysFile = this.getVar(SYSTEM_PROPERTIES).toString();
        }
        this.tryExec(sysFile);
        if (this.getVar(HOST_SYSTEM_PROPERTIES_FILE) != null) {
            sysFile = this.getVar(HOST_SYSTEM_PROPERTIES_FILE).toString();
            this.tryExec(sysFile);
        }
        this.listeners.forEach(l -> l.endSystemProperties(this));
        ThreadContext.put((String)"logDir", (String)System.getProperty("elements.common.logging.logDir"));
        logger.info("-> Log4J log4j.configurationFile={}", System.getProperty("log4j.configurationFile"));
        if (this.getVar(PRE_BOOT) != null) {
            p = this.getVar(PRE_BOOT);
            this.setupBootList(p, this.preBoot);
        }
        if (this.getVar(POST_BOOT) != null) {
            p = this.getVar(POST_BOOT);
            this.setupBootList(p, this.postBoot);
        }
        if (this.getVar(BOOT_DISABLE_LIST) != null) {
            p = this.getVar(BOOT_DISABLE_LIST);
            this.setupDisableList(p);
        }
        if (this.getVar(BOOT_AFTER) != null) {
            if (!(this.getVar(BOOT_AFTER) instanceof Map)) {
                throw new SystemException("Expecting variable bootAfter to be a Map instead of " + this.getVar(BOOT_AFTER).getClass());
            }
            p = (Map)this.getVar(BOOT_AFTER);
            p.forEach((key, value) -> {
                this.after.put(key, value);
                this.setComponent(key, true);
            });
        }
        this.listeners.forEach(l -> l.endEnv(this));
        this.bootEnv = true;
        logger.info("Done loading environment **********************************\n");
    }

    private void setupDisableList(Object p) {
        if (p instanceof List) {
            List list = (List)p;
            list.forEach(l -> this.disable(l.toString()));
        } else if (p != null) {
            this.disable(p.toString());
        }
    }

    private void setupBootList(Object p, Map bootList) {
        if (p instanceof Map) {
            Map map = (Map)p;
            map.forEach((key, value) -> {
                if (this.main.get(key) != null || this.after.get(key) != null) {
                    boolean on = true;
                    Object ret = this.runObject(value);
                    if (ret == null) {
                        on = false;
                    } else if (ret instanceof String || ret instanceof GString) {
                        on = "true".equalsIgnoreCase(ret.toString()) || "t".equalsIgnoreCase(ret.toString());
                    } else if (ret instanceof Boolean) {
                        on = (Boolean)ret;
                    }
                    this.expando.setProperty(key.toString(), on);
                } else {
                    bootList.put(key, value);
                    this.setComponent(key, true);
                }
            });
        } else if (p instanceof List) {
            List list = (List)p;
            list.forEach(l -> {
                this.expando.setProperty(l.toString(), true);
                this.updateBootList(l, bootList);
            });
        } else if (p != null) {
            this.updateBootList(p, bootList);
        }
    }

    private void updateBootList(Object p, Map bootList) {
        if (this.main.get(p) == null && this.after.get(p) == null) {
            String key = "anonymous-" + ++this.bootIndex;
            this.expando.setProperty(key, true);
            bootList.put(key, p);
        } else {
            this.expando.setProperty(p.toString(), true);
        }
    }

    private void bootProvision() {
        if (this.bootProvision) {
            return;
        }
        Class provisionClass = Provision.class;
        if (this.getVar(PROVISION_CLASS) != null) {
            provisionClass = (Class)this.getVar(PROVISION_CLASS);
        }
        this.resourceManager.loadProvision(provisionClass);
        if (this.getVar(PLUGIN_DIRECTORIES) != null) {
            Object dir = this.getVar(PLUGIN_DIRECTORIES);
            String[] pluginDirectories = new String[]{};
            if (dir instanceof Collection) {
                Collection collection = (Collection)dir;
                pluginDirectories = new String[collection.size()];
                Iterator iterator = collection.iterator();
                int idx = 0;
                while (iterator.hasNext()) {
                    pluginDirectories[idx] = iterator.next().toString();
                    ++idx;
                }
            } else if (dir instanceof Object[]) {
                Object[] array = (Object[])dir;
                pluginDirectories = new String[array.length];
                for (int i = 0; i < pluginDirectories.length; ++i) {
                    pluginDirectories[i] = array[i].toString();
                }
            }
            this.resourceManager.getPluginManager().loadPlugins(pluginDirectories);
        }
        this.bootProvision = true;
    }

    private void bootInitialContext() {
        InitialContextFactory.setDefault();
    }

    private void tryExec(String path) {
        try {
            this.resourceManager.getScripting().exec(path);
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof IOException) {
                logger.info("-> Script {} not processed: {}", path, e.getCause().getMessage());
            }
            logger.warn("!! Script not processed due to error.", e);
        }
    }

    private void initBoot() {
        if (this.bootInit) {
            return;
        }
        this.bootMessage("Boot initialization");
        this.initBoot.forEach(this::exec);
        logger.info("Done pre-booting ******************************************\n");
        this.bootInit = true;
    }

    private void bootMain() {
        this.bootMessage("Booting main");
        this.main.forEach(this::runComponent);
        logger.info("Done booting components **********************************\n");
    }

    private void preBoot() {
        this.bootMessage("Pre-booting");
        this.preBoot.forEach(this::runComponent);
        logger.info("Done pre-booting ******************************************\n");
    }

    private void postBoot() {
        this.bootMessage("Post-booting");
        this.postBoot.forEach(this::runComponent);
        logger.info("Done post-booting ******************************************\n");
    }

    private void bootAfter() {
        this.bootMessage("Boot after");
        this.after.forEach(this::runComponent);
        logger.info("Done boot after ********************************************\n");
    }

    public Bootstrap after(Map map) {
        map.forEach((key, value) -> {
            this.after.put(key, value);
            this.setComponent(key, true);
        });
        if (this.disableList != null) {
            for (String component : this.disableList) {
                this.expando.setProperty(component, false);
            }
        }
        this.bootAfter();
        return this;
    }

    private void runComponentMessage(String message) {
        String line = "    =======================================================";
        if (logger.isInfoEnabled()) {
            logger.info("    =======================================================");
            logger.info(message);
        }
    }

    private void runComponent(Object key, Object value) {
        if (key == null || this.bootComponents.contains(key.toString())) {
            return;
        }
        if (key instanceof Closure) {
            Closure closure = (Closure)key;
            this.runComponentMessage("    Running closure " + closure.toString());
            if (closure.isCase((Object)EMPTY_OBJECT_ARRAY)) {
                this.exec(value);
            } else if (logger.isInfoEnabled()) {
                logger.info("    !! Closure returns false, skipped running {}", value);
            }
            if (logger.isInfoEnabled()) {
                logger.info("    Done running {}", closure);
            }
        } else {
            Object on = this.expando.getProperty(key.toString());
            if (Boolean.TRUE.equals(on)) {
                this.runComponentMessage("    Booting *" + key + "*");
                this.exec(value);
            }
            if (logger.isInfoEnabled()) {
                logger.info("    Done booting *{}*", key);
            }
        }
        logger.info("    -------------------------------------------------------\n");
        this.bootComponents.add(key.toString());
    }

    private void exec(Object obj) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            for (Object script : collection) {
                this.runObject(script);
            }
        } else {
            this.runObject(obj);
        }
    }

    private Object runObject(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Closure) {
                Closure closure = (Closure)obj;
                closure.setDelegate((Object)this.expando);
                closure.setResolveStrategy(1);
                return closure.call((Object)this);
            }
            if (obj instanceof String || obj instanceof GString) {
                return this.resourceManager.getScripting().exec(obj.toString());
            }
            return obj;
        }
        catch (ScriptException ex) {
            throw new SystemException(ex);
        }
    }

    private Object getVar(String var) {
        return this.resourceManager.getScripting().get(var);
    }

    public void setupThreadPool(String threadPoolName) {
        ThreadPool threadPool = ThreadPool.cachedThreadPool(threadPoolName);
        logger.info(LINE_SEPARATOR);
        logger.info("Setting up thread pool {}", threadPoolName);
        logger.info(LINE_SEPARATOR);
        this.resourceManager.registerBean(threadPoolName, threadPool);
        this.resourceManager.bind(ThreadPool.class, this.resourceManager.getBean(threadPoolName));
    }

    public void shutdown(int shutdownPort) {
        try (Socket socket = new Socket(InetAddress.getLoopbackAddress(), shutdownPort);){
            PrintWriter output = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            output.println("shutdown");
            output.flush();
        }
        catch (Exception ex) {
            logger.warn("No local server found at port={}", shutdownPort);
        }
        System.exit(0);
    }

    public void startShutdownListener(int shutdownPort) {
        logger.info(LINE_SEPARATOR);
        logger.info("Starting server shutdown listening thread");
        logger.info(LINE_SEPARATOR);
        Thread thread = new Thread(() -> {
            try {
                ServerSocket serverSocket = new ServerSocket(shutdownPort, 0, InetAddress.getLoopbackAddress());
                while (true) {
                    Terminal terminal = null;
                    try {
                        terminal = new Terminal(serverSocket);
                    }
                    catch (IOException e) {
                        break;
                    }
                    if (!terminal.readLine("").equals("shutdown")) continue;
                    logger.info("Received shutdown request.  Shutting down ... ");
                    this.resourceManager.shutdown();
                    System.exit(0);
                }
                serverSocket.close();
            }
            catch (IOException ex) {
                logger.warn("Unable to start shutdown listener", ex);
            }
        });
        thread.start();
    }

    public static class ComponentInfo {
        private String stage;
        private String name;
        private boolean enabled;

        public String getStage() {
            return this.stage;
        }

        public void setStage(String stage) {
            this.stage = stage;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class MyExpando
    extends Expando {
        private MyExpando() {
        }

        public Object invokeMethod(String name, Object args) {
            try {
                return this.getMetaClass().invokeMethod((Object)this, name, args);
            }
            catch (GroovyRuntimeException e) {
                Object value = super.getProperty(name);
                if (value instanceof Closure) {
                    Closure closure = (Closure)value;
                    closure = (Closure)closure.clone();
                    closure.setDelegate((Object)this);
                    return closure.call((Object[])args);
                }
                throw e;
            }
        }

        public Object getProperty(String property) {
            Object result = this.getProperties().get(property);
            if (result != null) {
                return result;
            }
            return this.getMetaClass().getProperty((Object)this, property);
        }

        public void enable(String ... components) {
            if (components != null) {
                for (String component : components) {
                    this.setProperty(component, true);
                }
            }
        }

        public void disable(String ... components) {
            if (components != null) {
                for (String component : components) {
                    this.setProperty(component, false);
                }
            }
        }
    }
}

