/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import groovy.lang.Closure;
import groovy.lang.GString;
import java.beans.Introspector;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.script.Scripting;
import net.e6tech.elements.common.util.SystemException;

public abstract class AbstractScriptShell {
    private static Map<String, Object> constants = new HashMap<String, Object>();
    private static Logger logger = Logger.getLogger();
    private Map<String, List<String>> knownEnvironments = new LinkedHashMap<String, List<String>>();
    private Scripting scripting;
    private Properties properties;
    List<Runnable> cleanup = new LinkedList<Runnable>();
    boolean loading = false;

    protected AbstractScriptShell() {
    }

    protected AbstractScriptShell(Properties properties) {
        this.initialize(null, properties);
    }

    protected void initialize(ClassLoader classLoader, Properties props) {
        int idx;
        this.properties = props == null ? new Properties() : props;
        String originalScriptBase = this.properties.getProperty("scriptBaseClass");
        if (originalScriptBase == null) {
            String className = this.getClass().getName() + "Script";
            try {
                this.getClass().getClassLoader().loadClass(className);
                this.properties.put("scriptBaseClass", className);
            }
            catch (ClassNotFoundException e) {
                Logger.suppress(e);
            }
        }
        this.scripting = Scripting.newInstance(classLoader, this.properties);
        if (originalScriptBase == null) {
            this.properties.remove("scriptBaseClass");
        } else {
            this.properties.put("scriptBaseClass", originalScriptBase);
        }
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.length() == 0 && (idx = (simpleName = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            simpleName = simpleName.substring(idx + 1);
        }
        String shellName = Introspector.decapitalize(simpleName);
        this.scripting.put(shellName, this);
        this.scripting.put("shell", this);
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            this.scripting.put(entry.getKey(), entry.getValue());
        }
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public Object eval(String expression) {
        try {
            return this.getScripting().eval(expression);
        }
        catch (ScriptException e) {
            throw new SystemException(e);
        }
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void load(String str) throws ScriptException {
        try {
            this.loading = true;
            this.scripting.load(str);
            this.onLoaded();
        }
        finally {
            this.loading = false;
        }
    }

    protected void onLoaded() {
        for (Runnable r : this.cleanup) {
            r.run();
        }
        this.cleanup.clear();
    }

    public void addCleanup(Runnable r) {
        this.cleanup.add(r);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        this.scripting.put(key, value);
    }

    public <T> T nullableVar(String key) {
        return (T)this.getScripting().get(key);
    }

    public <T> Optional<T> getVariable(String key) {
        return Optional.ofNullable(this.nullableVar(key));
    }

    public Map<String, List<String>> defineKnownEnvironments(String str) {
        this.knownEnvironments = Configuration.defineEnvironments(str);
        return this.knownEnvironments;
    }

    public Map<String, List<String>> getKnownEnvironments() {
        return this.knownEnvironments;
    }

    public void setKnownEnvironments(Map<String, List<String>> knownEnvironments) {
        this.knownEnvironments = knownEnvironments;
    }

    public void runAfter(Object callable) {
        this.scripting.runAfter(callable);
    }

    public void runAfter(Runnable callable) {
        this.scripting.runAfter(callable);
    }

    public void runAfterIfNotLoading() {
        if (!this.loading) {
            this.scripting.runAfter();
        }
    }

    public Object runNow(Object caller, Object callable) {
        return this.scripting.runNow(caller, callable);
    }

    public Object runNow(Object caller, Runnable callable) {
        return this.scripting.runNow(caller, callable);
    }

    public Object runNow(Object caller, Callable callable) {
        return this.scripting.runNow(caller, callable);
    }

    public void runLaunched(Runnable callable) {
        this.scripting.runLaunched(callable);
    }

    public Object exec(String path) {
        try {
            return this.getScripting().exec(path);
        }
        catch (ScriptException e) {
            throw logger.systemException(e);
        }
    }

    public void exec(Object ... items) {
        Object value = null;
        for (Object item : items) {
            value = this.execItem(item, value);
        }
    }

    private Object execItem(Object item, Object val) {
        Object value = val;
        try {
            if (item instanceof String || item instanceof GString) {
                value = this.getScripting().exec(item.toString());
            } else if (item instanceof Closure) {
                Closure clonedClosure = (Closure)((Closure)item).clone();
                value = this.execClosure(clonedClosure, value);
            } else if (item instanceof String[]) {
                for (String str : (String[])item) {
                    value = this.getScripting().exec(str);
                }
            } else {
                value = item;
            }
        }
        catch (ScriptException e) {
            throw logger.systemException(e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execClosure(Closure closure, Object value) {
        try {
            closure.setResolveStrategy(1);
            closure.setDelegate(value);
            Object ret = closure.call(value);
            if (ret != null) {
                Object object = ret;
                return object;
            }
            Object object = value;
            return object;
        }
        finally {
            closure.setDelegate(null);
        }
    }

    public Dir dir(String dir) {
        return new Dir(dir);
    }

    static {
        constants.put("SECOND", 1000L);
        constants.put("MINUTE", 60000L);
        constants.put("HOUR", 3600000L);
        constants.put("DAY", 86400000L);
    }

    public static class Dir {
        private String directory;

        public Dir() {
            this.directory = "";
        }

        public Dir(String base) {
            this.directory = base;
            while ((this.directory.endsWith(File.separator) || this.directory.endsWith("/")) && !"classpath://".equals(this.directory) && !"classpath:/".equals(this.directory)) {
                this.directory = this.directory.substring(0, this.directory.length() - 1);
            }
        }

        public String[] expand(String ... items) {
            if (items == null) {
                return new String[0];
            }
            String[] paths = new String[items.length];
            for (int i = 0; i < paths.length; ++i) {
                String item = items[i];
                while (item.startsWith(File.separator) || item.startsWith("/")) {
                    item = item.substring(1);
                }
                if (!item.endsWith(".groovy")) {
                    item = item + ".groovy";
                }
                paths[i] = this.directory + "/" + item;
            }
            return paths;
        }
    }
}

