/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.file;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampDirectory {
    private String directory;

    public TimestampDirectory() {
    }

    public TimestampDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String outDir) {
        String outputDirectory = outDir;
        while (outputDirectory.endsWith(File.separator) || outputDirectory.endsWith("/")) {
            outputDirectory = outputDirectory.substring(0, outputDirectory.length() - 1);
        }
        this.directory = outputDirectory;
    }

    public Location open() {
        return new Location(this.directory);
    }

    public Location open(String baseDirectory) {
        return new Location(this.directory, baseDirectory);
    }

    public static class Location {
        private String rootDirectory;
        private String baseDirectory;
        private String directoryTimestampPattern = "yyyy/MM/dd";
        private String fileExtension;
        private String fileName;
        private String fileTimestampPattern = "yyyyMMddHHmm";

        public Location(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        public Location(String rootDirectory, String baseDirectory) {
            this.rootDirectory = rootDirectory;
            this.baseDirectory = baseDirectory;
        }

        public String baseDirectory() {
            return this.baseDirectory;
        }

        public Location baseDirectory(String rootDirectory) {
            this.baseDirectory = rootDirectory;
            return this;
        }

        public String directoryTimestampPattern() {
            return this.directoryTimestampPattern;
        }

        public Location directoryTimestampPattern(String directoryTimestampPattern) {
            this.directoryTimestampPattern = directoryTimestampPattern;
            return this;
        }

        public String fileName() {
            return this.fileName;
        }

        public Location fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public String fileExtension() {
            return this.fileExtension;
        }

        public Location fileExtension(String extension) {
            this.fileExtension = extension;
            return this;
        }

        public String fileTimestampPattern() {
            return this.fileTimestampPattern;
        }

        public Location fileTimestampPattern(String fileTimestampPattern) {
            this.fileTimestampPattern = fileTimestampPattern;
            return this;
        }

        public OutputStream getOutputStream() throws IOException {
            return Files.newOutputStream(this.getOutputPath(), new OpenOption[0]);
        }

        public OutputStream getOutputStream(String fileName, String extension) throws IOException {
            return Files.newOutputStream(this.getOutputPath(fileName, extension), new OpenOption[0]);
        }

        public OutputStream getOutputStream(String file, String ext, ZonedDateTime timestamp) throws IOException {
            return Files.newOutputStream(this.getOutputPath(file, ext, timestamp), new OpenOption[0]);
        }

        public Path getOutputPath() throws IOException {
            return this.getOutputPath(this.fileName, null, null);
        }

        public Path getOutputPath(String fileName, String extension) throws IOException {
            return this.getOutputPath(fileName, extension, null);
        }

        public Path getOutputPath(String file, String ext, ZonedDateTime timestamp) throws IOException {
            if (file != null) {
                this.fileName = file;
            }
            if (ext != null) {
                this.fileExtension = ext;
            }
            if (this.fileName == null) {
                throw new IOException("File name is not specified");
            }
            String timestampDir = "";
            if (this.directoryTimestampPattern != null && timestamp != null) {
                timestampDir = "/" + timestamp.format(DateTimeFormatter.ofPattern(this.directoryTimestampPattern));
            }
            String dir = this.baseDirectory != null ? this.rootDirectory + "/" + this.baseDirectory + timestampDir : this.rootDirectory + timestampDir;
            Path dirPath = Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
            String fullPath = this.fileName;
            if (this.fileTimestampPattern != null && timestamp != null) {
                fullPath = fullPath + timestamp.format(DateTimeFormatter.ofPattern(this.fileTimestampPattern));
            }
            if (this.fileExtension != null) {
                if (!this.fileExtension.startsWith(".")) {
                    this.fileExtension = "." + this.fileExtension;
                }
                fullPath = fullPath + this.fileExtension;
            }
            return Paths.get(dirPath.toString(), fullPath);
        }
    }
}

