/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Annotator;
import net.e6tech.elements.common.reflection.Lambda;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;

public class Annotated<R, A extends Annotation> {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static LoadingCache<Pair<Class<?>, Class<? extends Annotation>>, Annotated> annotatedCache = CacheBuilder.newBuilder().maximumSize(1000L).initialCapacity(100).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build(new CacheLoader<Pair<Class<?>, Class<? extends Annotation>>, Annotated>(){

        public Annotated load(Pair<Class<?>, Class<? extends Annotation>> pair) {
            return new Annotated(pair.key(), pair.value());
        }
    });
    private Class<A> annotationClass;
    private List<Entry<A>> entries = new ArrayList<Entry<A>>();
    private Cache<Pair<String, ?>, Lookup<A, ?, ?>> lookups = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).maximumSize(1000L).initialCapacity(16).build();

    public Annotated(Class<R> clazz, Class<A> annotationClass) {
        this.annotationClass = annotationClass;
        this.properties(clazz);
        this.fields(clazz);
        this.entries = Collections.unmodifiableList(this.entries);
    }

    public static <A extends Annotation, E, V> Accessor<A, E, V> accessor(Object target, Class<A> annotationClass, Function<A, E> function, Class<V> valueType) {
        Lookup<A, E, V> lookup = Annotated.lookup(target.getClass(), annotationClass, function, valueType);
        return lookup.accessor(target);
    }

    public static <A extends Annotation, E, V> Lookup<A, E, V> lookup(Class clazz, Class<A> annotationClass, Function<A, E> function, Class<V> valueType) {
        try {
            return ((Annotated)annotatedCache.get(new Pair<Class, Class<A>>(clazz, annotationClass))).lookup(function, valueType);
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    public <E, V> Lookup<A, E, V> lookup(Function<A, E> function, Class<V> valueType) {
        MyInvocationHandler handler = new MyInvocationHandler();
        Annotation proxy = (Annotation)Proxy.newProxyInstance(this.annotationClass.getClassLoader(), new Class[]{this.annotationClass}, (InvocationHandler)handler);
        function.apply(proxy);
        Method method = handler.method;
        if (method == null) {
            throw new IllegalArgumentException("Null annotation method for " + this.annotationClass);
        }
        try {
            return (Lookup)this.lookups.get(new Pair<String, Class<V>>(method.getName(), valueType), () -> new Lookup(this, method, valueType));
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    private void fields(Class<R> clazz) {
        for (Class<R> cls = clazz; cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                A e = field.getDeclaredAnnotation(this.annotationClass);
                if (e == null) continue;
                this.entries.add(new Entry<A>(e, field));
            }
        }
    }

    private void properties(Class<R> clazz) {
        BeanInfo beanInfo = Reflection.getBeanInfo(clazz);
        for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
            Object e = null;
            if (prop.getWriteMethod() != null) {
                e = prop.getWriteMethod().getDeclaredAnnotation(this.annotationClass);
            }
            if (e == null && prop.getReadMethod() != null) {
                e = prop.getReadMethod().getDeclaredAnnotation(this.annotationClass);
            }
            if (e == null) continue;
            this.entries.add(new Entry<Object>(e, prop.getName(), prop.getReadMethod(), prop.getWriteMethod()));
        }
    }

    private static class MyInvocationHandler
    implements InvocationHandler {
        Method method;

        private MyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!Annotator.objectMethods.containsKey(method.getName()) || method.getParameterCount() != Annotator.objectMethods.get(method.getName()).intValue()) {
                this.method = method;
            }
            if (method.getReturnType().isPrimitive()) {
                return Primitives.defaultValue(method.getReturnType());
            }
            return null;
        }
    }

    public static class Accessor<A extends Annotation, E, V> {
        private Object target;
        private Lookup<A, E, V> lookup;

        Accessor(Lookup<A, E, V> lookup, Object target) {
            this.lookup = lookup;
            this.target = target;
        }

        public V get(E annotatedValue) {
            Map<Object, List<Entry<A>>> result = this.lookup.find(annotatedValue);
            List<Entry<A>> list = result.get(annotatedValue);
            if (list != null) {
                return (V)list.get(0).get(this.target);
            }
            return null;
        }

        public Map<E, V> get(E ... annotatedValues) {
            HashMap<E, Object> map = new HashMap<E, Object>();
            Map<E, List<Entry<A>>> result = this.lookup.find(annotatedValues);
            for (Map.Entry<E, List<Entry<A>>> e : result.entrySet()) {
                map.put(e.getKey(), e.getValue().get(0).get(this.target));
            }
            return map;
        }

        public Map<E, V> getAll() {
            HashMap<E, Object> map = new HashMap<E, Object>();
            for (Map.Entry<E, List<Entry<A>>> e : this.lookup.annotationValues().entrySet()) {
                map.put(e.getKey(), e.getValue().get(0).get(this.target));
            }
            return map;
        }

        public Accessor<A, E, V> set(E annotatedValue, Object value) {
            Map<Object, List<Entry<A>>> result = this.lookup.find(annotatedValue);
            List<Entry<A>> list = result.get(annotatedValue);
            if (list != null && list.size() > 0) {
                list.get(0).set(this.target, value);
            }
            return this;
        }
    }

    public static class Lookup<A extends Annotation, E, V> {
        private Map<E, List<Entry<A>>> annotationValues;
        private List<Entry<A>> entries = new ArrayList<Entry<A>>();

        Lookup(Annotated<?, A> annotated, Method method, Class<V> valueClass) {
            this.annotationValues = new HashMap<E, List<Entry<A>>>();
            for (Entry e : ((Annotated)annotated).entries) {
                if (valueClass != null && !valueClass.isAssignableFrom(e.getRawType())) continue;
                Object value = null;
                try {
                    value = method.invoke(e.annotation, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                List list = this.annotationValues.computeIfAbsent(value, key2 -> new ArrayList());
                list.add(e);
                this.entries.add(e);
            }
            this.entries = Collections.unmodifiableList(this.entries);
            this.annotationValues = Collections.unmodifiableMap(this.annotationValues);
        }

        public List<Entry<A>> entries() {
            return this.entries;
        }

        public Map<E, List<Entry<A>>> annotationValues() {
            return this.annotationValues;
        }

        public Map<E, List<Entry<A>>> find(E ... searchValues) {
            HashMap<E, List<Entry<A>>> result = new HashMap<E, List<Entry<A>>>();
            if (searchValues != null) {
                for (E searchValue : searchValues) {
                    List<Entry<A>> found = this.annotationValues.get(searchValue);
                    if (found == null) continue;
                    result.put(searchValue, found);
                }
            } else {
                result.putAll(this.annotationValues);
            }
            return result;
        }

        public Accessor<A, E, V> accessor(Object target) {
            return new Accessor(this, target);
        }
    }

    public static class Entry<A> {
        private String name;
        private MethodHandle setter;
        private MethodHandle getter;
        private Function lambdaGetter;
        private BiConsumer lambdaSetter;
        private A annotation;
        private Type type;
        private Class<?> rawType;

        Entry(A annotation, String name, Method getter, Method setter) {
            this.annotation = annotation;
            this.name = name;
            try {
                if (setter != null) {
                    this.setter = lookup.unreflect(setter);
                    this.type = setter.getGenericParameterTypes()[0];
                    this.rawType = setter.getParameterTypes()[0];
                    this.lambdaSetter = Lambda.reflectSetter(lookup, setter);
                }
                if (getter != null) {
                    this.getter = lookup.unreflect(getter);
                    this.type = getter.getGenericReturnType();
                    this.rawType = getter.getReturnType();
                    this.lambdaGetter = Lambda.reflectGetter(lookup, getter);
                }
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }

        Entry(A annotation, Field field) {
            this.annotation = annotation;
            this.name = field.getName();
            this.type = field.getGenericType();
            this.rawType = field.getType();
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            try {
                this.setter = lookup.unreflectSetter(field);
                this.getter = lookup.unreflectGetter(field);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }

        public Object get(Object target) {
            Object value = null;
            if (this.lambdaGetter != null) {
                value = this.lambdaGetter.apply(target);
            } else if (this.getter != null) {
                try {
                    value = this.getter.invoke(target);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return value;
        }

        public void set(Object target, Object value) {
            if (this.lambdaSetter != null) {
                this.lambdaSetter.accept(target, value);
            } else if (this.setter != null) {
                try {
                    this.setter.invoke(target, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public <T extends Annotation> T getAnnotation() {
            return (T)((Annotation)this.annotation);
        }

        public Type getType() {
            return this.type;
        }

        public Class<?> getRawType() {
            return this.rawType;
        }
    }
}

