/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.stream.Stream;

public class FileUtil {
    private static final String[] EMPTY_FILE_LIST = new String[0];

    private FileUtil() {
    }

    public static String[] listFiles(String path, String extension) throws IOException {
        String[] paths = EMPTY_FILE_LIST;
        if (path.endsWith("**")) {
            String dir = path.substring(0, path.length() - 2);
            if (Paths.get(dir, new String[0]).toFile().isDirectory()) {
                paths = FileUtil.listFiles(dir, extension, true);
            } else if (!Paths.get(dir, new String[0]).toFile().exists()) {
                throw new IOException("Directory " + dir + " does not exist");
            }
        } else if (path.endsWith("*")) {
            String dir = path.substring(0, path.length() - 1);
            if (Paths.get(dir, new String[0]).toFile().isDirectory()) {
                paths = FileUtil.listFiles(dir, extension, false);
            } else if (!Paths.get(dir, new String[0]).toFile().exists()) {
                throw new IOException("Directory " + dir + " does not exist");
            }
        } else {
            paths = FileUtil.getSingleFile(path, extension);
        }
        return paths;
    }

    private static String[] getSingleFile(String path, String extension) {
        String p;
        String string = p = path.endsWith(extension) ? path : path + extension;
        if (path.startsWith("classpath:")) {
            return new String[]{p};
        }
        File f = new File(p);
        if (!f.isDirectory() && f.exists()) {
            return new String[]{p};
        }
        return EMPTY_FILE_LIST;
    }

    private static String[] listFiles(String path, String extension, boolean recursive) throws IOException {
        LinkedList<String> directories = new LinkedList<String>();
        LinkedList<String> list = new LinkedList<String>();
        if (new File(path).isDirectory()) {
            directories.add(path);
        } else if (extension == null || path.endsWith(extension)) {
            list.add(path);
        }
        while (!directories.isEmpty()) {
            String parent = (String)directories.remove(0);
            Stream<Path> stream = Files.list(Paths.get(parent, new String[0]));
            Throwable throwable = null;
            try {
                stream.forEach(f -> {
                    if (f.toFile().isDirectory()) {
                        if (recursive) {
                            directories.add(f.toString());
                        }
                    } else if (extension == null || f.toString().endsWith(extension)) {
                        list.add(f.toString());
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

