/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.configure;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.configure.Resolver;

public class ObjectConfig {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final String RESOLVER_START = "^";
    private String resolverIndicator = "^";
    private String prefix = "";
    private Resolver resolver;
    private Object instance;
    private Type instanceType;
    private InstanceCreationListener instanceCreationListener;
    private String current = "";
    private ObjectConfig parent;

    public ObjectConfig() {
    }

    private ObjectConfig(ObjectConfig parent) {
        this.parent = parent;
    }

    public ObjectConfig prefix(String prefix) {
        String string = this.prefix = prefix == null ? "" : prefix.trim();
        while (this.prefix.length() > 0 && this.prefix.charAt(prefix.length() - 1) == '.') {
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1).trim();
        }
        if (this.prefix.length() > 0) {
            this.prefix = this.prefix + ".";
        }
        return this;
    }

    public ObjectConfig resolver(Resolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ObjectConfig resolverIndicator(String str) {
        this.resolverIndicator = str;
        return this;
    }

    public ObjectConfig instance(Object instance) {
        this.instance = instance;
        return this;
    }

    public ObjectConfig type(Type type) {
        this.instanceType = type;
        return this;
    }

    public ObjectConfig creationListener(InstanceCreationListener listener) {
        this.instanceCreationListener = listener;
        return this;
    }

    protected ObjectConfig newChild(Object instance, Type toType) {
        return new ObjectConfig(this).instance(instance).type(toType).resolver(this.resolver).resolverIndicator(this.resolverIndicator).creationListener(this.instanceCreationListener);
    }

    /*
     * WARNING - void declaration
     */
    public void configure(Map<?, ?> map) throws Exception {
        String key;
        void var6_8;
        if (this.instance instanceof Map) {
            this.configureMap(map);
            return;
        }
        HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
        BeanInfo info = Introspector.getBeanInfo(this.instance.getClass());
        PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            PropertyDescriptor desc = propertyDescriptorArray[var6_8];
            descriptors.put(desc.getName(), desc);
            ++var6_8;
        }
        LinkedHashMap links = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            key = entry.getKey().toString();
            String key2 = key + ".";
            this.current = "";
            if (this.prefix.length() > 0 && !key.startsWith(this.prefix) && !key2.equals(this.prefix)) continue;
            if (this.prefix.length() > 0 && key.startsWith(this.prefix)) {
                key = key.substring(this.prefix.length()).trim();
            } else if (key2.equals(this.prefix)) {
                key = "";
            }
            if (key.contains(".")) {
                links.put(key, entry.getValue());
                continue;
            }
            if (key.length() == 0) {
                this.newChild(this.instance, null).configure(this.asMap(entry.getValue()));
                continue;
            }
            PropertyDescriptor desc = (PropertyDescriptor)descriptors.get(key);
            if (desc == null || desc.getWriteMethod() == null) continue;
            this.current = entry.getKey().toString();
            desc.getWriteMethod().invoke(this.instance, this.convert(entry.getValue(), desc.getWriteMethod().getGenericParameterTypes()[0]));
        }
        for (Map.Entry<Object, Object> entry : links.entrySet()) {
            key = (String)entry.getKey();
            Object value = entry.getValue();
            String[] components = key.split("\\.");
            Object obj = this.instance;
            for (int i = 0; i < components.length - 1; ++i) {
                try {
                    Object child = Reflection.getProperty(obj, components[i].trim());
                    if (child == null) {
                        PropertyDescriptor desc = new PropertyDescriptor(components[i], obj.getClass());
                        if (Map.class.isAssignableFrom(desc.getPropertyType())) {
                            child = new LinkedHashMap();
                        } else {
                            child = desc.getPropertyType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (this.instanceCreationListener != null) {
                                this.instanceCreationListener.instanceCreated(child, desc.getPropertyType(), child);
                            }
                        }
                        desc.getWriteMethod().invoke(obj, child);
                    }
                    obj = child;
                    continue;
                }
                catch (Exception ex) {
                    throw new SystemException(this.instance.getClass().getName() + "." + key + ": No such property " + components[i], ex);
                }
            }
            if (obj == null) continue;
            try {
                PropertyDescriptor desc = new PropertyDescriptor(components[components.length - 1], obj.getClass());
                if (desc == null || desc.getWriteMethod() == null) break;
                Object val = this.convert(value, desc.getWriteMethod().getGenericParameterTypes()[0]);
                desc.getWriteMethod().invoke(obj, val);
            }
            catch (IntrospectionException ex) {
                throw new SystemException(this.instance.getClass().getName() + "." + key + ": No such property " + components[components.length - 1], ex);
            }
        }
    }

    private void configureMap(Map map) {
        Map instanceMap = (Map)this.instance;
        for (Object k : map.keySet()) {
            String key = k.toString();
            String key2 = k + ".";
            if ("".equals(this.prefix) || key.startsWith(this.prefix)) {
                String subkey = key.substring(this.prefix.length());
                if (this.instance instanceof Properties) {
                    instanceMap.put(subkey, this.resolve(map.get(key).toString()));
                    continue;
                }
                Object val = map.get(key);
                if (val instanceof String) {
                    val = this.resolve(val.toString());
                }
                instanceMap.put(subkey, val);
                continue;
            }
            if (!key2.equals(this.prefix)) continue;
            this.newChild(this.instance, null).configureMap(this.asMap(map.get(key)));
        }
    }

    private Object resolve(String value) {
        if (this.resolver == null || value == null) {
            return value;
        }
        String str = value.trim();
        if (str.startsWith(this.resolverIndicator)) {
            str = str.substring(this.resolverIndicator.length()).trim();
            return this.resolver.resolve(str);
        }
        return value;
    }

    private Class getRawType(Type toType) {
        Class cls = null;
        if (toType instanceof Class) {
            cls = (Class)toType;
        } else if (toType instanceof ParameterizedType) {
            cls = (Class)((ParameterizedType)toType).getRawType();
        } else if (toType instanceof GenericArrayType) {
            cls = this.getComponentClass((GenericArrayType)toType);
        } else if (toType instanceof TypeVariable && this.instanceType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)this.instanceType;
            int index = 0;
            for (TypeVariable tv : ((Class)pType.getRawType()).getTypeParameters()) {
                if (tv.getName().equals(((TypeVariable)toType).getName())) {
                    Type type = pType.getActualTypeArguments()[index];
                    cls = this.getRawType(type);
                    break;
                }
                ++index;
            }
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot deduce class for type=" + toType + ", path=" + this.getPath());
        }
        return cls;
    }

    private Class getComponentClass(GenericArrayType arrayType) {
        Class cls;
        Type componentType = arrayType.getGenericComponentType();
        if (componentType instanceof Class) {
            cls = (Class)componentType;
        } else if (componentType instanceof ParameterizedType) {
            cls = (Class)((ParameterizedType)componentType).getRawType();
        } else {
            throw new IllegalArgumentException("Cannot deduce component class for type=" + arrayType + ", path=" + this.getPath());
        }
        return cls;
    }

    private Object convert(Object value, Type toType) throws Exception {
        Class cls = this.getRawType(toType);
        if (cls.isArray() || toType instanceof GenericArrayType) {
            return this.convertToArray(this.asCollection(value), toType);
        }
        if (String.class.isAssignableFrom(cls)) {
            String str = value == null ? null : value.toString();
            return this.resolve(str);
        }
        if (Map.class.isAssignableFrom(cls)) {
            return this.convertToMap(this.asMap(value), toType);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return this.convertToCollection(this.asCollection(value), toType);
        }
        if (value instanceof Map) {
            LinkedHashMap child = Map.class.isAssignableFrom(cls) ? new LinkedHashMap() : cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.newChild(child, toType).configure(this.asMap(value));
            return child;
        }
        if (value == null && cls.isPrimitive()) {
            return Primitives.defaultValue(cls);
        }
        String str = mapper.writeValueAsString(value);
        return mapper.readValue(str, cls);
    }

    private Map asMap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalArgumentException("Cannot cast object of class=" + value.getClass() + " to Map, path=" + this.getPath());
    }

    private Collection asCollection(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            return list;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        throw new IllegalArgumentException("Cannot cast object of class=" + value.getClass() + " to Map, path=" + this.getPath());
    }

    private Collection convertToCollection(Collection collection, Type toType) throws Exception {
        AbstractCollection converted;
        if (collection == null) {
            return null;
        }
        Class rawType = this.getRawType(toType);
        if (List.class.isAssignableFrom(rawType)) {
            converted = new ArrayList();
        } else if (Set.class.isAssignableFrom(rawType)) {
            converted = new HashSet();
        } else {
            throw new IllegalArgumentException("Cannot convert object of class=" + collection.getClass() + " to Collection, path=" + this.getPath());
        }
        if (toType instanceof Class) {
            converted.addAll(collection);
        } else {
            ParameterizedType parametrized = (ParameterizedType)toType;
            Type componentType = parametrized.getActualTypeArguments()[0];
            for (Object component : collection) {
                converted.add(this.convert(component, componentType));
            }
        }
        return converted;
    }

    private Object convertToArray(Collection collection, Type toType) throws Exception {
        Type componentType;
        if (collection == null) {
            return null;
        }
        Class rawType = null;
        if (toType instanceof Class) {
            componentType = rawType = ((Class)toType).getComponentType();
        } else if (toType instanceof ParameterizedType) {
            ParameterizedType parametrized = (ParameterizedType)toType;
            rawType = componentType = parametrized.getRawType();
        } else if (toType instanceof GenericArrayType) {
            componentType = ((GenericArrayType)toType).getGenericComponentType();
            rawType = this.getRawType(toType);
        } else {
            throw new IllegalArgumentException("Cannot deduce component class for type=" + toType + ", path=" + this.getPath());
        }
        Object converted = Array.newInstance(rawType, collection.size());
        Iterator iterator = collection.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object member = iterator.next();
            Array.set(converted, index, this.convert(member, componentType));
            ++index;
        }
        return converted;
    }

    private Map convertToMap(Map<?, ?> map, Type toType) throws Exception {
        if (map == null) {
            return null;
        }
        LinkedHashMap<Object, Object> converted = new LinkedHashMap<Object, Object>();
        if (toType instanceof Class) {
            converted.putAll(map);
        } else {
            ParameterizedType parametrized = (ParameterizedType)toType;
            Type valueType = parametrized.getActualTypeArguments()[1];
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                converted.put(entry.getKey().toString(), this.convert(entry.getValue(), valueType));
            }
        }
        return converted;
    }

    protected String getPath() {
        StringBuilder builder = new StringBuilder();
        if (this.parent != null) {
            builder.append(this.parent.getPath()).append('.');
        }
        builder.append(this.current);
        return builder.toString();
    }

    static {
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    @FunctionalInterface
    public static interface InstanceCreationListener {
        public void instanceCreated(Object var1, Class var2, Object var3);
    }
}

