/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor.builder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.builder.BuiltInTypes;
import net.e6tech.elements.common.interceptor.builder.DefaultBuiltInTypes;
import net.e6tech.elements.common.util.SystemException;

public class Builder<T>
implements InterceptorHandler {
    private static Interceptor interceptor = new Interceptor();
    protected static Cache<Class, Map<String, String>> propertyNames = CacheBuilder.newBuilder().concurrencyLevel(32).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).initialCapacity(50).build();
    protected static Cache<Class, Map<String, PropertyDescriptor>> descriptors = CacheBuilder.newBuilder().concurrencyLevel(32).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).initialCapacity(50).build();
    private T target;
    private T proxy;
    private Map<String, Builder> children = new HashMap<String, Builder>();
    private BuiltInTypes builtInTypes = new DefaultBuiltInTypes();

    public static XMLGregorianCalendar buildXMLGregorianCalendar(ZonedDateTime zonedDateTime) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano() / 1000000, zonedDateTime.getOffset().getTotalSeconds() / 60);
        }
        catch (DatatypeConfigurationException e) {
            throw new SystemException(e);
        }
    }

    public Builder(Class<T> jaxbClass) {
        try {
            this.target = jaxbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.proxy = interceptor.newInterceptor(this.target, this);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public Builder(T target) {
        try {
            this.target = target;
            if (target != null) {
                this.proxy = interceptor.newInterceptor(target, this);
            }
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public T getTarget() {
        return this.target;
    }

    protected void setTarget(T target) {
        this.target = target;
        if (target != null) {
            this.proxy = interceptor.newInterceptor(target, this);
        }
    }

    protected T getProxy() {
        return this.proxy;
    }

    public BuiltInTypes getBuiltInTypes() {
        return this.builtInTypes;
    }

    public void setBuiltInTypes(BuiltInTypes builtInTypes) {
        this.builtInTypes = builtInTypes;
    }

    public T accept(Consumer<T> consumer) {
        consumer.accept(this.proxy);
        return this.target;
    }

    @Override
    public Object invoke(CallFrame frame) throws Throwable {
        String methodName = frame.getMethod().getName();
        String propertyName = this.getPropertyName(methodName);
        if (propertyName == null) {
            return frame.invoke();
        }
        if (frame.getMethod().getParameterCount() == 0 && (methodName.startsWith("get") || methodName.startsWith("is"))) {
            return this.get(propertyName, frame);
        }
        if (frame.getMethod().getParameterCount() == 1 && methodName.length() > 3 && methodName.startsWith("set") && Character.isUpperCase(methodName.charAt(3))) {
            this.set(propertyName, frame);
            return null;
        }
        return frame.invoke();
    }

    protected boolean isBuiltInClass(Class type) {
        return this.builtInTypes.isBuiltInClass(type);
    }

    protected PropertyDescriptor getDescriptor(String propertyName) {
        if (this.target != null) {
            Map descMap = (Map)descriptors.getIfPresent(this.target.getClass());
            if (descMap == null) {
                this.introspect();
                descMap = (Map)descriptors.getIfPresent(this.target.getClass());
            }
            return (PropertyDescriptor)descMap.get(propertyName);
        }
        return null;
    }

    protected String getPropertyName(String methodName) {
        if (this.target != null) {
            Map properties = (Map)propertyNames.getIfPresent(this.target.getClass());
            if (properties == null) {
                this.introspect();
                properties = (Map)propertyNames.getIfPresent(this.target.getClass());
            }
            return (String)properties.get(methodName);
        }
        return null;
    }

    protected void introspect() {
        try {
            HashMap<String, PropertyDescriptor> descMap = new HashMap<String, PropertyDescriptor>();
            HashMap<String, String> properties = new HashMap<String, String>();
            BeanInfo beanInfo = Introspector.getBeanInfo(this.target.getClass());
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                if (desc.getName().equals("class")) continue;
                if (desc.getReadMethod() != null) {
                    properties.put(desc.getReadMethod().getName(), desc.getName());
                }
                if (desc.getWriteMethod() != null) {
                    properties.put(desc.getWriteMethod().getName(), desc.getName());
                }
                descMap.put(desc.getName(), desc);
            }
            descriptors.put(this.target.getClass(), descMap);
            propertyNames.put(this.target.getClass(), properties);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    protected Object get(String propertyName, CallFrame frame) {
        Method setter;
        Class<?> returnType = frame.getMethod().getReturnType();
        if (this.isBuiltInClass(returnType)) {
            return frame.invoke();
        }
        PropertyDescriptor descriptor = this.getDescriptor(propertyName);
        Method method = setter = descriptor == null ? null : descriptor.getWriteMethod();
        if (setter == null) {
            return frame.invoke();
        }
        Builder child = this.children.computeIfAbsent(propertyName, key -> {
            try {
                Builder<Object> c;
                Object existing = frame.invoke();
                if (existing != null) {
                    c = new Builder<Object>(existing);
                } else {
                    c = new Builder<Class>(returnType);
                    setter.invoke(this.target, c.target);
                }
                return c;
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        });
        return child.proxy;
    }

    protected void set(String propertyName, CallFrame frame) {
        Class<?> type = frame.getMethod().getParameterTypes()[0];
        if (this.isBuiltInClass(type)) {
            frame.invoke();
            return;
        }
        Object value = frame.getArguments()[0];
        if (Interceptor.isProxyObject(value) && Interceptor.getInterceptorHandler(value) instanceof Builder) {
            Builder child = (Builder)Interceptor.getInterceptorHandler(value);
            this.children.put(propertyName, child);
            value = child.target;
        } else {
            Builder<Object> child = new Builder<Object>(value);
            this.children.put(propertyName, child);
        }
        frame.getArguments()[0] = value;
        frame.invoke();
    }
}

