/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;

public class Interceptor {
    private LoadingCache<Class, Class> proxyClasses = CacheBuilder.newBuilder().initialCapacity(100).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build((CacheLoader)new CacheLoader<Class, Class>(){

        public Class load(Class cls) {
            return new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)MethodDelegation.toField((String)Interceptor.HANDLER_FIELD)).defineField(Interceptor.HANDLER_FIELD, Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{HandlerAccessor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make().load(cls.getClassLoader()).getLoaded();
        }
    });
    private static final String HANDLER_FIELD = "handler";
    private static Interceptor instance = new Interceptor();

    public static Interceptor getInstance() {
        return instance;
    }

    public static <T> Class<T> newPrototypeClass(Class<T> cls, T prototype) {
        return new ByteBuddy().subclass(cls).constructor((ElementMatcher)ElementMatchers.any()).intercept(SuperMethodCall.INSTANCE.andThen((Implementation)MethodDelegation.to(new Constructor<T>(prototype)))).make().load(cls.getClassLoader()).getLoaded();
    }

    public static <T> Class<T> newSingletonClass(Class<T> cls, T singleton) {
        return Interceptor.newSingletonClass(cls, singleton, null);
    }

    public static <T> Class<T> newSingletonClass(Class<T> cls, T singleton, InterceptorListener listener) {
        if (singleton == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        Class proxyClass = new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"finalize").and((ElementMatcher)ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.none()))))).intercept((Implementation)MethodDelegation.toField((String)HANDLER_FIELD)).defineField(HANDLER_FIELD, Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, Ownership.STATIC}).make().load(cls.getClassLoader()).getLoaded();
        try {
            Field field = proxyClass.getDeclaredField(HANDLER_FIELD);
            field.setAccessible(true);
            InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(Interceptor.getInstance(), proxyClass, singleton, ctx -> ctx.invoke(singleton), listener);
            field.set(null, wrapper);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return proxyClass;
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler) {
        return this.newInterceptor(instance, handler, null);
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler, InterceptorListener listener) {
        Class proxyClass = this.createClass(instance.getClass());
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(this, proxyClass, instance, handler, listener);
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler) {
        return this.newInstance(cls, handler, null);
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler, InterceptorListener listener) {
        Class proxyClass = this.createClass(cls);
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = null;
        try {
            Object target = null;
            if (!cls.isInterface()) {
                target = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            wrapper = new InterceptorHandlerWrapper(this, proxyClass, target, handler, listener);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        wrapper.targetClass = cls;
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    protected Class createClass(Class cls) {
        try {
            return (Class)this.proxyClasses.get((Object)cls);
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    private <T> T newObject(Class proxyClass) {
        T proxyObject = null;
        try {
            proxyObject = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return proxyObject;
    }

    public static boolean isProxyObject(Object proxyObject) {
        return proxyObject instanceof HandlerAccessor;
    }

    public static <T> T cloneProxyObject(T proxyObject) {
        if (!(proxyObject instanceof HandlerAccessor)) {
            throw new IllegalArgumentException("argument is not a proxy object");
        }
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper = new InterceptorHandlerWrapper(wrapper);
        Interceptor interceptor = wrapper.interceptor;
        T cloneProxy = interceptor.newObject(wrapper.proxyClass);
        ((HandlerAccessor)cloneProxy).setHandler(wrapper);
        return cloneProxy;
    }

    public static Object getTarget(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return wrapper.target;
    }

    public static void setTarget(Object proxyObject, Object target) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        if (target != null && !target.getClass().isAssignableFrom(wrapper.targetClass)) {
            throw new IllegalArgumentException("Target class " + target.getClass() + " is not assignable from " + wrapper.targetClass);
        }
        wrapper.target = target;
    }

    public static Class getTargetClass(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return wrapper.targetClass;
    }

    public static <T extends InterceptorHandler> T getInterceptorHandler(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.handler;
    }

    public static <T extends InterceptorHandler> void setInterceptorHandler(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.handler = handler;
    }

    public static <T extends InterceptorListener> T getInterceptorListener(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.listener;
    }

    public static <T extends InterceptorListener> void setInterceptorListener(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.listener = handler;
    }

    private static class InterceptorHandlerWrapper
    implements Handler {
        InterceptorHandler handler;
        InterceptorListener listener;
        Object target;
        Class targetClass;
        Class proxyClass;
        Interceptor interceptor;

        InterceptorHandlerWrapper(Interceptor interceptor, Class proxyClass, Object target, InterceptorHandler handler, InterceptorListener listener) {
            this.interceptor = interceptor;
            this.proxyClass = proxyClass;
            this.handler = handler;
            this.listener = listener;
            this.target = target;
            if (target != null) {
                this.targetClass = target.getClass();
            }
        }

        InterceptorHandlerWrapper(InterceptorHandlerWrapper copy) {
            this.interceptor = copy.interceptor;
            this.proxyClass = copy.proxyClass;
            this.handler = copy.handler;
            this.listener = copy.listener;
            this.target = copy.target;
            this.targetClass = copy.targetClass;
        }

        @Override
        public Object handle(MethodHandle methodHandle, Method method, @RuntimeType Object[] arguments) throws Throwable {
            CallFrame frame = new CallFrame(this.target, methodHandle, method, arguments);
            if (this.listener != null) {
                this.listener.preInvocation(frame);
            }
            Object ret = null;
            try {
                ret = this.handler.invoke(frame);
            }
            catch (Throwable throwable) {
                if (this.listener != null) {
                    return this.listener.onException(frame, throwable);
                }
                throw throwable;
            }
            if (this.listener != null) {
                ret = this.listener.postInvocation(frame, ret);
            }
            return ret;
        }
    }

    public static interface HandlerAccessor {
        public Handler getHandler();

        public void setHandler(Handler var1);
    }

    @FunctionalInterface
    public static interface Handler {
        @RuntimeType
        public Object handle(@Origin MethodHandle var1, @Origin Method var2, @AllArguments Object[] var3) throws Throwable;
    }

    public static class Constructor<T> {
        T prototype;

        public Constructor(T prototype) {
            this.prototype = prototype;
        }

        public void construct(@This Object instance) {
            if (this.prototype != null) {
                Reflection.copyInstance(instance, this.prototype);
            }
        }
    }
}

