/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class Terminal
implements Closeable {
    Emulator emulator;

    public Terminal() {
        Console console = System.console();
        this.emulator = console != null ? new NativeConsole(console) : new StreamConsole(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(new OutputStreamWriter(System.out))){

            @Override
            public void close() {
            }
        };
    }

    public Terminal(InputStream in, OutputStream out) {
        this.emulator = new StreamConsole(new BufferedReader(new InputStreamReader(in)), new PrintWriter(new OutputStreamWriter(out)));
    }

    public Terminal(ServerSocket serverSocket) throws IOException {
        final Socket socket = serverSocket.accept();
        try {
            this.emulator = new StreamConsole(new BufferedReader(new InputStreamReader(socket.getInputStream())), new PrintWriter(new OutputStreamWriter(socket.getOutputStream()))){

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            Logger.suppress(e);
                        }
                    }
                }
            };
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public String readLine(String text) {
        return this.emulator.readLine(text);
    }

    public char[] readPassword(String text) {
        return this.emulator.readPassword(text);
    }

    public void println(String text) {
        this.emulator.println(text);
    }

    public void print(String text) {
        this.emulator.print(text);
    }

    @Override
    public void close() {
        this.emulator.close();
    }

    public static void main(String ... args) {
        String user = null;
        char[] password = null;
        try (Terminal term = new Terminal();){
            user = term.readLine("Username:");
            password = term.readPassword("Password:");
        }
        System.out.println(user + ":" + new String(password));
    }

    class NativeConsole
    implements Emulator {
        Console console;

        NativeConsole(Console console) {
            this.console = console;
        }

        @Override
        public String readLine(String text) {
            this.print(text);
            try {
                return this.console.readLine().trim();
            }
            catch (NullPointerException e) {
                Logger.suppress(e);
                return "";
            }
        }

        @Override
        public char[] readPassword(String text) {
            try {
                char[] ret = this.console.readPassword(text, new Object[0]);
                if (ret == null) {
                    return new char[0];
                }
                return ret;
            }
            catch (NullPointerException e) {
                Logger.suppress(e);
                return new char[0];
            }
        }

        @Override
        public void println(String text) {
            this.console.printf(text, new Object[0]);
            this.console.printf("\n", new Object[0]);
        }

        @Override
        public void print(String text) {
            this.console.printf(text, new Object[0]);
        }

        @Override
        public void close() {
        }
    }

    class StreamConsole
    implements Emulator {
        private BufferedReader input;
        private PrintWriter output;

        StreamConsole(BufferedReader in, PrintWriter out) {
            this.input = in;
            this.output = out;
        }

        @Override
        public String readLine(String text) {
            this.output.print(text);
            this.output.flush();
            try {
                return this.input.readLine().trim();
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            catch (NullPointerException e) {
                Logger.suppress(e);
                return null;
            }
        }

        @Override
        public char[] readPassword(String text) {
            this.output.println(text);
            this.output.flush();
            String str = null;
            try {
                str = this.input.readLine().trim();
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            catch (NullPointerException e) {
                Logger.suppress(e);
                return null;
            }
            return str.toCharArray();
        }

        @Override
        public void println(String text) {
            this.output.println(text);
            this.output.flush();
        }

        @Override
        public void print(String text) {
            this.output.print(text);
            this.output.flush();
        }

        @Override
        public void close() {
            IOException exception = null;
            try {
                this.input.close();
            }
            catch (IOException e) {
                exception = e;
            }
            this.output.close();
            if (exception != null) {
                throw new SystemException(exception);
            }
        }
    }

    static interface Emulator {
        public String readLine(String var1);

        public char[] readPassword(String var1);

        public void println(String var1);

        public void print(String var1);

        public void close();
    }
}

