/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.ObjectConverter;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.ResourcesFactory;
import net.e6tech.elements.common.resources.UnitOfWork;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.SystemException;

public class Provision {
    public static Integer cacheBuilderConcurrencyLevel = 32;
    private ResourceManager resourceManager;

    public Provision load(Map<String, Object> map) {
        Class<?> cls = this.getClass();
        while (Provision.class.isAssignableFrom(cls)) {
            Field[] fields;
            for (Field f : fields = cls.getDeclaredFields()) {
                this.setField(f, map);
            }
            cls = cls.getSuperclass();
        }
        return this;
    }

    private void setField(Field f, Map<String, Object> map) {
        Object from;
        ObjectConverter converter = new ObjectConverter();
        if (Modifier.isPublic(f.getModifiers()) && !Modifier.isStatic(f.getModifiers()) && map.get(f.getName()) != null && (from = map.get(f.getName())) != null) {
            try {
                f.setAccessible(true);
                f.set(this, converter.convert(from, f, null));
                f.setAccessible(false);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
    }

    public void log(Logger logger, LogLevel level, String message, Throwable th) {
        logger.log(level, message, th);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Inject
    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public <T> T getComponentResource(String componentName, String resourceName) {
        return this.getResourceManager().getAtomResource(componentName, resourceName);
    }

    public String getName() {
        return this.resourceManager.getName();
    }

    public <T> T nullableVar(String key) {
        return this.resourceManager.nullableVar(key);
    }

    public <T> Optional<T> getVariable(String key) {
        return this.resourceManager.getVariable(key);
    }

    public Properties getProperties() {
        return this.resourceManager.getProperties();
    }

    public Map<String, List<String>> getKnownEnvironments() {
        return this.resourceManager.getKnownEnvironments();
    }

    public <T> T getBean(String name) {
        return this.resourceManager.getBean(name);
    }

    public <T> T getBean(Class<T> cls) {
        return this.resourceManager.getBean(cls);
    }

    public Map<String, Object> getBeans() {
        return this.resourceManager.getBeans();
    }

    public <T> Map<String, T> getBeans(Class<T> cls) {
        return this.resourceManager.getBeans(cls);
    }

    public List listBeans() {
        return this.resourceManager.listBeans();
    }

    public <T> T getInstance(Class<T> cls) {
        return this.resourceManager.getInstance(cls);
    }

    public <T> T newInstance(Class<T> cls) {
        return this.resourceManager.newInstance(cls);
    }

    public <T> T inject(T obj) {
        return this.resourceManager.inject(obj);
    }

    public Class<? extends Resources> getResourcesClass() {
        return Resources.class;
    }

    public <S, T extends Plugin> Optional<T> getPlugin(Class<S> c1, String n1, Class<T> c2, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2), args);
    }

    public <R, S, T extends Plugin> Optional<T> getPlugin(Class<R> c1, String n1, Class<S> c2, String n2, Class<T> c3, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Plugin> Optional<T> getPlugin(PluginPath<T> path, Object ... args) {
        return this.getInstance(PluginManager.class).get(path, args);
    }

    public UnitOfWork open() {
        UnitOfWork unitOfWork = new UnitOfWork(this.resourceManager);
        return unitOfWork.preOpen(null);
    }

    public UnitOfWork preOpen(Consumer<Resources> consumer) {
        UnitOfWork unitOfWork = new UnitOfWork(this.resourceManager);
        return unitOfWork.preOpen(consumer);
    }

    public UnitOfWork onOpen(OnOpen onOpen) {
        UnitOfWork unitOfWork = new UnitOfWork(this.resourceManager);
        return unitOfWork.onOpen(onOpen);
    }

    public ResourcesFactory resourcesFactory() {
        ResourcesFactory factory = new ResourcesFactory();
        this.inject(factory);
        return factory;
    }
}

