/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginPath;

public class PluginMap<K, V>
implements PluginFactory {
    private Map<K, Object> map = new LinkedHashMap<K, Object>();
    private PluginPath pluginPath;
    private Resources resources;

    public PluginMap<K, V> create(Resources resources) {
        PluginMap<K, V> copy = new PluginMap<K, V>();
        copy.resources = resources;
        copy.map = this.map;
        return copy;
    }

    @Override
    public void initialize(PluginPath path) {
        this.pluginPath = path;
    }

    protected void put(K key, V singleton) {
        this.map.put(key, singleton);
    }

    protected void put(K key, Class<? extends V> cls) {
        this.map.put(key, cls);
    }

    public Map<K, V> map() {
        return this.resources.configurator().computeIfAbsent(this.pluginPath.path(), key -> {
            LinkedHashMap<K, Object> m = new LinkedHashMap<K, Object>();
            for (Map.Entry<K, Object> entry : this.map.entrySet()) {
                Object value = entry.getValue() instanceof Class ? this.resources.newInstance((Class)entry.getValue()) : entry.getValue();
                m.put(entry.getKey(), value);
            }
            return m;
        });
    }
}

