/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.spi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Named;
import net.e6tech.elements.common.inject.spi.Binding;
import net.e6tech.elements.common.inject.spi.ModuleImpl;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;

public class InjectorImpl
implements Injector {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static LoadingCache<Class<?>, List<InjectionPoint>> injectionPoints = CacheBuilder.newBuilder().maximumSize(10000L).initialCapacity(200).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build(new CacheLoader<Class<?>, List<InjectionPoint>>(){

        public List<InjectionPoint> load(Class<?> instanceClass) {
            List points = InjectorImpl.injectionProperties(instanceClass);
            points.addAll(InjectorImpl.injectionFields(instanceClass));
            return points;
        }
    });
    private ModuleImpl module;
    private InjectorImpl parentInjector;

    InjectorImpl(ModuleImpl module, InjectorImpl parentInjector) {
        this.module = module;
        this.parentInjector = parentInjector;
    }

    @Override
    public <T> T getInstance(Class<T> cls) {
        return this.getNamedInstance(cls, null);
    }

    @Override
    public <T> T getNamedInstance(Class<T> boundClass, String name) {
        return this.privateGetNamedInstance(boundClass, name).map(binding -> binding.getValue()).orElse(null);
    }

    private Optional<Binding> privateGetNamedInstance(Type boundClass, String name) {
        Type type = boundClass;
        Binding binding = this.module.getBinding(type, name);
        if (binding == null && type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            binding = this.module.getBinding(type, name);
        }
        if (binding != null) {
            binding = binding.getInstance(this);
        } else if (this.parentInjector != null) {
            binding = this.parentInjector.privateGetNamedInstance(boundClass, name).orElse(null);
        }
        return Optional.ofNullable(binding);
    }

    @Override
    public void inject(Object instance) {
        if (instance == null) {
            return;
        }
        Class<?> instanceClass = instance.getClass();
        try {
            List points = (List)injectionPoints.get(instanceClass);
            points.forEach(pt -> {
                boolean injected = this.inject((InjectionPoint)pt, instance);
                if (!injected) {
                    throw new SystemException("Cannot inject " + pt + "; no instances bound to " + pt.getType());
                }
            });
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    protected boolean inject(InjectionPoint point, Object instance) {
        InjectionAttempt attempt = point.inject(this, instance);
        if (attempt == InjectionAttempt.INJECTED) {
            return true;
        }
        if (this.parentInjector != null) {
            return this.parentInjector.inject(point, instance);
        }
        return attempt != InjectionAttempt.ERROR;
    }

    private static List<InjectionPoint> injectionFields(Class instanceClass) {
        ArrayList<InjectionPoint> list = new ArrayList<InjectionPoint>();
        for (Class cls = instanceClass; cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                InjectionPoint injectionPoint = InjectorImpl.injectionPoint(field, () -> new InjectionPoint(field)).orElse(null);
                if (injectionPoint == null) continue;
                list.add(injectionPoint);
            }
        }
        return list;
    }

    private static List<InjectionPoint> injectionProperties(Class instanceClass) {
        ArrayList<InjectionPoint> list = new ArrayList<InjectionPoint>();
        BeanInfo beanInfo = Reflection.getBeanInfo(instanceClass);
        for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
            InjectionPoint injectionPoint = InjectorImpl.injectionPoint(prop.getWriteMethod(), () -> new InjectionPoint(prop.getWriteMethod())).orElseGet(() -> InjectorImpl.injectionPoint(prop.getReadMethod(), () -> new InjectionPoint(prop.getWriteMethod())).orElse(null));
            if (injectionPoint == null) continue;
            list.add(injectionPoint);
        }
        return list;
    }

    private static Optional<InjectionPoint> injectionPoint(AccessibleObject accessibleObject, Supplier<InjectionPoint> supplier) {
        if (accessibleObject == null) {
            return Optional.empty();
        }
        Inject inject = accessibleObject.getDeclaredAnnotation(Inject.class);
        InjectionPoint injectionPoint = null;
        if (inject != null) {
            injectionPoint = supplier.get();
            injectionPoint.optional = inject.optional();
            injectionPoint.type = inject.type();
            injectionPoint.property = inject.property();
        } else {
            javax.inject.Inject jInject = accessibleObject.getDeclaredAnnotation(javax.inject.Inject.class);
            if (jInject != null) {
                injectionPoint = supplier.get();
                injectionPoint.optional = false;
            }
        }
        if (injectionPoint != null) {
            Named named = accessibleObject.getDeclaredAnnotation(Named.class);
            if (named != null) {
                injectionPoint.name = named.value();
            } else {
                javax.inject.Named jNamed = accessibleObject.getDeclaredAnnotation(javax.inject.Named.class);
                if (jNamed != null) {
                    injectionPoint.name = jNamed.value();
                }
            }
        }
        return Optional.ofNullable(injectionPoint);
    }

    private static class InjectionPoint {
        protected String name;
        protected boolean optional;
        protected Class type = Void.TYPE;
        protected String property = "";
        private MethodHandle setter;
        private Type setterType;
        private AccessibleObject accessible;

        InjectionPoint(Method setter) {
            try {
                this.accessible = setter;
                this.setterType = setter.getGenericParameterTypes()[0];
                this.setter = lookup.unreflect(setter);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }

        InjectionPoint(Field field) {
            this.accessible = field;
            this.setterType = field.getGenericType();
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            try {
                this.setter = lookup.unreflectSetter(field);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }

        InjectionAttempt inject(InjectorImpl injector, Object target) {
            Type t = this.getType();
            Optional opt = injector.privateGetNamedInstance(t, this.name);
            if (!opt.isPresent() && !this.optional) {
                return InjectionAttempt.ERROR;
            }
            if (opt.isPresent()) {
                try {
                    Object value = ((Binding)opt.get()).getValue();
                    if (this.property.length() > 0 && value != null) {
                        value = Reflection.getProperty(value, this.property);
                    }
                    this.setter.invoke(target, value);
                }
                catch (IllegalAccessException e) {
                    throw new SystemException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SystemException(e.getTargetException());
                }
                catch (Throwable e) {
                    throw new SystemException(e);
                }
                return InjectionAttempt.INJECTED;
            }
            return InjectionAttempt.NOT_INJECTED;
        }

        Type getType() {
            return this.type != Void.TYPE && this.type != Void.class ? this.type : this.setterType;
        }

        public String toString() {
            return this.accessible.toString();
        }
    }

    private static enum InjectionAttempt {
        ERROR,
        INJECTED,
        NOT_INJECTED;

    }
}

