/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.function.FunctionWithException;

public abstract class Balancer<T> {
    private BlockingQueue<T> liveList = new LinkedBlockingQueue<T>();
    private BlockingQueue<T> deadList = new LinkedBlockingQueue<T>();
    private long timeout = 3000L;
    private long recoveryPeriod = 60000L;
    private Thread recoveryThread;
    private volatile boolean stopped = false;

    public T getService() {
        Class cls = Reflection.getParametrizedType(this.getClass(), 0);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (proxy, method, args) -> this.execute(service -> method.invoke(service, args)));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getRecoveryPeriod() {
        return this.recoveryPeriod;
    }

    public void setRecoveryPeriod(long recoveryPeriod) {
        this.recoveryPeriod = recoveryPeriod;
    }

    public void addService(T service) {
        this.liveList.add(service);
    }

    public void start() {
        Iterator iterator = this.liveList.iterator();
        this.stopped = false;
        while (iterator.hasNext()) {
            Object service = iterator.next();
            try {
                this.start(service);
            }
            catch (Exception th) {
                Logger.suppress(th);
                iterator.remove();
                this.recover(service);
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }

    protected abstract void start(T var1) throws IOException;

    protected abstract void stop(T var1) throws IOException;

    private void recoverTask() {
        LinkedList list = new LinkedList();
        while (!this.stopped) {
            list.clear();
            Object service = this.deadList.poll();
            try {
                this.start(service);
                this.liveList.offer(service);
            }
            catch (Exception ex) {
                Logger.suppress(ex);
                try {
                    this.stop(service);
                }
                catch (Exception e) {
                    Logger.suppress(e);
                }
                list.add(service);
            }
            list.forEach(h -> this.deadList.offer(h));
            try {
                Thread.sleep(this.recoveryPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected synchronized void recover(T service) {
        try {
            this.stop(service);
        }
        catch (Exception e) {
            Logger.suppress(e);
        }
        this.deadList.offer(service);
        if (this.recoveryThread == null) {
            this.recoveryThread = new Thread(this::recoverTask);
            this.recoveryThread.start();
        }
    }

    public <R> R execute(FunctionWithException<T, R, Exception> submit) throws IOException {
        SystemException error;
        do {
            T service;
            try {
                service = this.liveList.poll(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException();
            }
            if (service == null) {
                throw new IOException("No service available");
            }
            error = null;
            try {
                R ret = submit.apply(service);
                this.liveList.offer(service);
                return ret;
            }
            catch (IOException ex) {
                Logger.suppress(ex);
                this.recover(service);
            }
            catch (InvocationTargetException e) {
                error = new SystemException(e.getCause());
            }
            catch (SystemException e) {
                error = e;
            }
            catch (RuntimeException e) {
                error = new SystemException(e.getCause());
            }
            catch (Exception e) {
                error = new SystemException(e);
            }
            this.liveList.offer(service);
        } while (error == null);
        throw error;
    }
}

