/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class TextSubstitution {
    private Map<String, Var> variables = new LinkedHashMap<String, Var>();
    private Map<String, Var> declared = new LinkedHashMap<String, Var>();
    private String template;

    public TextSubstitution(String template) {
        this.template = template;
        this.parseVariableNames(template);
    }

    public TextSubstitution(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int len = 0;
        while ((len = reader.read(buffer)) >= 0) {
            builder.append(buffer, 0, len);
        }
        this.template = builder.toString();
        this.parseVariableNames(this.template);
        reader.close();
    }

    public String getTemplate() {
        return this.template;
    }

    public TextSubstitution declare(String var) {
        this.declared.put(var, new Var(var));
        return this;
    }

    public String build(Object binding) {
        if (this.template == null) {
            return "";
        }
        String text = this.template;
        for (Map.Entry<String, Var> entry : this.variables.entrySet()) {
            Var var = entry.getValue();
            text = this.replaceVariable(entry.getKey(), var.build(binding), text);
        }
        return text;
    }

    private String replaceVariable(String key, String value, String text) {
        return text.replace("${" + key + "}", value);
    }

    private void parseVariableNames(String text) {
        int end;
        this.variables.clear();
        LinkedList<String> expressions = new LinkedList<String>();
        int pos = 0;
        int max = text.length();
        while (pos < max && (pos = text.indexOf("${", pos)) != -1 && (end = text.indexOf(125, pos + 2)) != -1) {
            String name = text.substring(pos + 2, end);
            expressions.add(name);
            pos = end + 1;
        }
        Iterator iterator = expressions.iterator();
        while (iterator.hasNext()) {
            String[] tokens;
            Var var;
            int index;
            String expression;
            String key = expression = (String)iterator.next();
            String defVal = null;
            String strategy = null;
            if (expression.contains(":+")) {
                index = expression.indexOf(":+");
                if (index >= 0) {
                    key = expression.substring(0, index).trim();
                    defVal = expression.substring(index + 2);
                    strategy = ":+";
                }
            } else if (expression.contains(":") && (index = expression.indexOf(58)) >= 0) {
                key = expression.substring(0, index).trim();
                defVal = expression.substring(index + 1);
                strategy = ":";
            }
            index = 0;
            for (int i = 0; i < key.length(); ++i) {
                if (Character.isWhitespace(key.codePointAt(i))) continue;
                index = i;
                break;
            }
            String leadingSpaces = key.substring(0, index);
            index = key.length();
            for (int i = key.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(key.codePointAt(i))) continue;
                index = i + 1;
                break;
            }
            String trailingSpaces = "";
            if (index < key.length()) {
                trailingSpaces = key.substring(index);
            }
            var = (var = this.declared.get((tokens = key.split("\\."))[0])) == null ? new Var(expression) : new Var(var);
            var.leading = leadingSpaces;
            var.trailing = trailingSpaces;
            var.defaultValue = defVal;
            var.strategy = strategy;
            var.path = tokens;
            this.variables.put(expression, var);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static class Var {
        String name;
        String leading;
        String trailing;
        String defaultValue;
        String strategy;
        String[] path;

        Var(String name) {
            this.name = name;
        }

        Var(Var var) {
            this.name = var.name;
            this.leading = var.leading;
            this.trailing = var.trailing;
            this.defaultValue = var.defaultValue;
            this.strategy = var.strategy;
            this.path = var.path;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String build(Object object) {
            Object result = object;
            for (String comp : this.path) {
                if ((comp = comp.trim()).isEmpty()) {
                    result = null;
                    continue;
                }
                try {
                    if (result == null) break;
                    if (result instanceof Map) {
                        result = ((Map)result).get(comp);
                        continue;
                    }
                    try {
                        PropertyDescriptor desc = new PropertyDescriptor(comp, result.getClass(), "is" + TextSubstitution.capitalize(comp), null);
                        result = desc.getReadMethod().invoke(result, new Object[0]);
                    }
                    catch (IntrospectionException ex) {
                        Logger.suppress(ex);
                        result = null;
                    }
                }
                catch (Exception e) {
                    Logger.suppress(e);
                    throw new SystemException(e);
                }
            }
            if (result == null) {
                if (":+".equals(this.strategy)) {
                    return "";
                }
                if (":".equals(this.strategy)) {
                    return this.defaultValue == null ? "" : this.defaultValue;
                }
                return "";
            }
            if (":+".equals(this.strategy)) {
                return this.defaultValue;
            }
            if (":".equals(this.strategy)) {
                return result.toString();
            }
            return this.leading + result.toString() + this.trailing;
        }
    }
}

