/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.util.Expando;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.common.util.SystemException;
import org.apache.logging.log4j.ThreadContext;

public class Bootstrap
extends GroovyObjectSupport {
    private static final String PRE_BOOT = "preBoot";
    private static final String POST_BOOT = "postBoot";
    private static final String BOOT_ENV = "bootEnv";
    private static final String PLUGIN_DIRECTORIES = "pluginDirectories";
    private static final String PROVISION_CLASS = "provisionClass";
    private static final String HOST_ENVIRONMENT_FILE = "hostEnvironmentFile";
    private static final String HOST_SYSTEM_PROPERTIES_FILE = "hostSystemPropertiesFile";
    private static final String ENVIRONMENT = "environment";
    private static final String SYSTEM_PROPERTIES = "systemProperties";
    private static Logger logger = Logger.getLogger();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String bootstrapDir = ".";
    private String defaultEnvironmentFile;
    private String defaultSystemProperties;
    private List initBoot = new ArrayList();
    private List preBoot = new ArrayList();
    private Map main = new LinkedHashMap();
    private List postBoot = new ArrayList();
    private Map after = new LinkedHashMap();
    private ResourceManager resourceManager;
    private MyExpando expando = new MyExpando();
    private boolean envInitialized = false;

    public Bootstrap(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public Map getMain() {
        return this.main;
    }

    public void setMain(Map main) {
        this.main = main;
        main.keySet().forEach(this::setComponent);
    }

    public String getDir() {
        return this.bootstrapDir;
    }

    public void setDir(String dir) {
        this.bootstrapDir = dir;
    }

    public String getDefaultEnvironmentFile() {
        return this.defaultEnvironmentFile;
    }

    public void setDefaultEnvironmentFile(String defaultEnvironmentFile) {
        this.defaultEnvironmentFile = defaultEnvironmentFile;
    }

    public String getDefaultSystemProperties() {
        return this.defaultSystemProperties;
    }

    public void setDefaultSystemProperties(String defaultSystemProperties) {
        this.defaultSystemProperties = defaultSystemProperties;
    }

    public List<String> getInitBoot() {
        return this.initBoot;
    }

    public void setInitBoot(List initBoot) {
        this.initBoot = initBoot;
    }

    public List<String> getInit() {
        return this.initBoot;
    }

    public void setInit(List initBoot) {
        this.initBoot = initBoot;
    }

    public Map getAfter() {
        return this.after;
    }

    public void setAfter(Map after) {
        this.after = after;
        after.keySet().forEach(this::setComponent);
    }

    private void setComponent(Object key) {
        if (key instanceof Closure) {
            Closure closure = (Closure)key;
            closure.setDelegate((Object)this.expando);
            closure.setResolveStrategy(1);
        } else {
            String propertyName = key.toString();
            this.expando.setProperty(propertyName, false);
        }
    }

    private void bootMessage(String message) {
        String line = "***********************************************************";
        if (logger.isInfoEnabled()) {
            logger.info(line);
            logger.info(message);
            logger.info(line);
        }
    }

    public void enable(String ... components) {
        this.expando.enable(components);
    }

    public void disable(String ... components) {
        this.expando.disable(components);
    }

    public void boot(String ... components) {
        if (this.main.isEmpty() && this.after.isEmpty()) {
            logger.warn("Components not configured.  Use main or after to configure components.");
        }
        this.bootMessage("Loading environment");
        this.bootEnv();
        logger.info("Done loading environment **********************************\n");
        this.bootProvision();
        this.bootInitialContext();
        if (components != null) {
            for (String component : components) {
                if (this.after.get(component) == null && this.main.get(component) == null) {
                    this.main.put(component, this.bootstrapDir + File.separator + component);
                }
                this.expando.setProperty(component, true);
            }
        }
        this.bootMessage("Boot initialization");
        this.initBoot();
        logger.info("Done pre-booting ******************************************\n");
        this.bootMessage("Pre-booting");
        this.preBoot();
        logger.info("Done pre-booting ******************************************\n");
        this.bootMessage("Booting main");
        this.bootMain();
        logger.info("Done booting components **********************************\n");
        this.bootMessage("Post-booting");
        this.postBoot();
        logger.info("Done post-booting ******************************************\n");
        this.bootMessage("Boot after");
        this.bootAfter();
        logger.info("Done boot after ********************************************\n");
        this.bootMessage("Booting completed");
    }

    private void bootEnv() {
        Object p;
        if (this.envInitialized) {
            return;
        }
        if (this.defaultEnvironmentFile != null) {
            this.exec(this.defaultEnvironmentFile);
        } else {
            String script = this.getVar("__dir") + "/environment.groovy";
            File file = new File(script);
            if (file.exists()) {
                this.exec(script);
            } else {
                logger.warn("!! No default environment script.");
            }
        }
        String envFile = this.getVar("__load_dir") + "/environment.groovy";
        if (this.getVar(ENVIRONMENT) != null) {
            envFile = this.getVar(ENVIRONMENT).toString();
        }
        this.tryExec(envFile);
        Object bootEnv = this.getVar(BOOT_ENV);
        if (bootEnv instanceof Map) {
            Map map = (Map)bootEnv;
            map.forEach((key, val) -> this.resourceManager.getScripting().put((String)key, val));
        }
        if (this.getVar(HOST_ENVIRONMENT_FILE) != null) {
            envFile = this.getVar(HOST_ENVIRONMENT_FILE).toString();
            this.tryExec(envFile);
        }
        if (this.defaultSystemProperties != null) {
            this.exec(this.defaultSystemProperties);
        } else {
            String script = this.getVar("__dir") + "/system_properties.groovy";
            this.tryExec(script);
        }
        String sysFile = this.getVar("__load_dir") + "/system_properties.groovy";
        if (this.getVar(SYSTEM_PROPERTIES) != null) {
            sysFile = this.getVar(SYSTEM_PROPERTIES).toString();
        }
        this.tryExec(sysFile);
        if (this.getVar(HOST_SYSTEM_PROPERTIES_FILE) != null) {
            sysFile = this.getVar(HOST_SYSTEM_PROPERTIES_FILE).toString();
            this.tryExec(sysFile);
        }
        ThreadContext.put((String)"logDir", (String)System.getProperty("elements.common.logging.logDir"));
        logger.info("-> Log4J log4j.configurationFile=" + System.getProperty("log4j.configurationFile"));
        if (this.getVar(PRE_BOOT) != null) {
            p = this.getVar(PRE_BOOT);
            this.setupBootList(p, this.preBoot);
        }
        if (this.getVar(POST_BOOT) != null) {
            p = this.getVar(POST_BOOT);
            this.setupBootList(p, this.postBoot);
        }
        this.envInitialized = true;
    }

    private void setupBootList(Object p, List bootList) {
        if (p instanceof List) {
            List list = (List)p;
            list.forEach(l -> {
                if (this.main.get(l) != null || this.after.get(l) != null) {
                    this.expando.setProperty(l.toString(), true);
                } else {
                    bootList.add(l);
                }
            });
        } else if (p != null) {
            if (this.main.get(p) != null || this.after.get(p) != null) {
                this.expando.setProperty(p.toString(), true);
            } else {
                bootList.add(p);
            }
        }
    }

    private void bootProvision() {
        Class provisionClass = Provision.class;
        if (this.getVar(PROVISION_CLASS) != null) {
            provisionClass = (Class)this.getVar(PROVISION_CLASS);
        }
        this.resourceManager.loadProvision(provisionClass);
        if (this.getVar(PLUGIN_DIRECTORIES) != null) {
            Object dir = this.getVar(PLUGIN_DIRECTORIES);
            String[] pluginDirectories = new String[]{};
            if (dir instanceof Collection) {
                Collection collection = (Collection)dir;
                pluginDirectories = new String[collection.size()];
                Iterator iterator = collection.iterator();
                int idx = 0;
                while (iterator.hasNext()) {
                    pluginDirectories[idx] = iterator.next().toString();
                    ++idx;
                }
            } else if (dir instanceof Object[]) {
                Object[] array = (Object[])dir;
                pluginDirectories = new String[array.length];
                for (int i = 0; i < pluginDirectories.length; ++i) {
                    pluginDirectories[i] = array[i].toString();
                }
            }
            this.resourceManager.getPluginManager().loadPlugins(pluginDirectories);
        }
    }

    private void bootInitialContext() {
        InitialContextFactory.setDefault();
    }

    private void tryExec(String path) {
        try {
            this.resourceManager.getScripting().exec(path);
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof IOException) {
                logger.info("-> Script " + path + " not processed: " + e.getCause().getMessage());
            }
            logger.warn("!! Script not processed due to error.", e);
        }
    }

    private void initBoot() {
        this.initBoot.forEach(this::exec);
    }

    private void bootMain() {
        this.main.forEach(this::runComponent);
    }

    private void preBoot() {
        this.preBoot.forEach(this::exec);
    }

    private void postBoot() {
        this.postBoot.forEach(this::exec);
    }

    private void bootAfter() {
        this.after.forEach(this::runComponent);
    }

    private void runComponentMessage(String message) {
        String line = "    =======================================================";
        if (logger.isInfoEnabled()) {
            logger.info("    =======================================================");
            logger.info(message);
        }
    }

    private void runComponent(Object key, Object value) {
        if (key instanceof Closure) {
            Closure closure = (Closure)key;
            this.runComponentMessage("    Running closure " + closure.toString());
            if (closure.isCase((Object)EMPTY_OBJECT_ARRAY)) {
                this.exec(value);
            } else if (logger.isInfoEnabled()) {
                logger.info("    !! Closure returns false, skipped running {}", value.toString());
            }
            if (logger.isInfoEnabled()) {
                logger.info("    Done running {}", closure.toString());
            }
        } else {
            Object on = this.expando.getProperty(key.toString());
            if (Boolean.TRUE.equals(on)) {
                this.runComponentMessage("    Booting *" + key + "*");
                this.exec(value);
            }
            if (logger.isInfoEnabled()) {
                logger.info("    Done booting *{}*", key);
            }
        }
        logger.info("    -------------------------------------------------------\n");
    }

    private void exec(Object obj) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            for (Object script : collection) {
                this.runObject(script);
            }
        } else {
            this.runObject(obj);
        }
    }

    private void runObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj instanceof Closure) {
                Closure closure = (Closure)obj;
                closure.setDelegate((Object)this.expando);
                closure.setResolveStrategy(1);
                closure.call((Object)this);
            } else {
                this.resourceManager.getScripting().exec(obj.toString());
            }
        }
        catch (ScriptException ex) {
            throw new SystemException(ex);
        }
    }

    private Object getVar(String var) {
        return this.resourceManager.getScripting().get(var);
    }

    private class MyExpando
    extends Expando {
        private MyExpando() {
        }

        public Object getProperty(String property) {
            Object result = this.getProperties().get(property);
            if (result != null) {
                return result;
            }
            return this.getMetaClass().getProperty((Object)this, property);
        }

        public void enable(String ... components) {
            if (components != null) {
                for (String component : components) {
                    this.setProperty(component, true);
                }
            }
        }

        public void disable(String ... components) {
            if (components != null) {
                for (String component : components) {
                    this.setProperty(component, false);
                }
            }
        }
    }
}

