/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import net.e6tech.elements.common.cache.CacheProvider;
import net.e6tech.elements.common.util.SystemException;

public class CacheConfiguration {
    public static final long DEFAULT_EXPIRY = 900000L;
    private static final String DEFAULT_PROVIDER = "net.e6tech.elements.common.cache.ehcache.EhcacheProvider";
    private static Map<String, CacheManager> managers = Collections.synchronizedMap(new HashMap());
    private CacheProvider provider;
    private CacheManager cacheManager;
    private String name;
    private long expiry = 900000L;
    private long maxEntries = 1024L;
    private boolean storeByValue = false;

    public CacheProvider getProvider() {
        return this.provider;
    }

    public void setProvider(CacheProvider provider) {
        this.provider = provider;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        if (expiry <= 0L) {
            throw new IllegalArgumentException();
        }
        this.expiry = expiry;
    }

    public long getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(long maxEntries) {
        this.maxEntries = maxEntries;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    public synchronized CacheManager getCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        if (this.provider == null) {
            try {
                this.provider = (CacheProvider)this.getClass().getClassLoader().loadClass(DEFAULT_PROVIDER).newInstance();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        this.cacheManager = managers.computeIfAbsent(this.provider.getProviderClassName(), key -> Caching.getCachingProvider((String)key).getCacheManager());
        return this.cacheManager;
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.getCache(name, keyClass, valueClass);
        if (cache != null) {
            return cache;
        }
        try {
            return this.provider.createCache(this, name, keyClass, valueClass);
        }
        catch (CacheException ex) {
            cache = cacheManager.getCache(name, keyClass, valueClass);
            if (cache != null) {
                return cache;
            }
            throw ex;
        }
    }
}

