/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Transactional;

public class Bindings {
    private Resources resources;
    private Map<Class, Binding> bindings = new HashMap<Class, Binding>();

    public Bindings(Resources resources) {
        this.resources = resources;
    }

    public <T> T get(Class<T> cls) {
        Binding binding = this.bindings.computeIfAbsent(cls, key -> this.resources.getBinding(cls));
        return binding.get();
    }

    public <T> Bindings rebind(Class<T> cls, T newValue) {
        Binding binding = this.bindings.computeIfAbsent(cls, key -> this.resources.getBinding(cls));
        binding.rebind(newValue);
        return this;
    }

    public void restore() {
        this.bindings.values().forEach(Binding::restore);
    }

    public <E extends Exception> void rebind(Transactional.ConsumerWithException<Bindings, E> consumer) throws E {
        try {
            consumer.accept(this);
        }
        finally {
            this.restore();
        }
    }

    public <T, E extends Exception> T rebind(Transactional.FunctionWithException<Bindings, T, E> function) throws E {
        try {
            T t = function.apply(this);
            return t;
        }
        finally {
            this.restore();
        }
    }
}

