/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.e6tech.elements.common.resources.Configurable;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Transactional;

public class UnitOfWork
implements Transactional,
Configurable<UnitOfWork> {
    ResourceManager resourceManager;
    List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    Consumer<Resources> preOpen;
    private Configurator configurator = new Configurator();
    Resources resources;
    List<Transactional.ConsumerWithException<? extends Resources>> unitOfWork = new LinkedList<Transactional.ConsumerWithException<? extends Resources>>();

    public UnitOfWork(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public UnitOfWork preOpen(Consumer<Resources> consumer) {
        this.preOpen = consumer;
        return this;
    }

    public UnitOfWork onOpen(OnOpen onOpen) {
        this.resourceProviders.add(onOpen);
        return this;
    }

    public Resources getResources() {
        return this.resources;
    }

    @Override
    public Configurator configurator() {
        return this.configurator;
    }

    @Override
    public UnitOfWork configurable() {
        return this;
    }

    @Override
    public <Res extends Resources> Res open() {
        if (this.resources != null && this.resources.isOpen()) {
            return (Res)this.resources;
        }
        this.resources = this.resourceManager.open(this.configurator, r -> {
            if (this.preOpen != null) {
                this.preOpen.accept((Resources)r);
            }
            for (ResourceProvider p : this.resourceProviders) {
                r.addResourceProvider(p);
            }
        });
        return (Res)this.resources;
    }

    public void commit() {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.commit();
        this.cleanup();
    }

    public void abort() {
        if (this.resources == null || !this.resources.isOpen()) {
            return;
        }
        this.resources.abort();
        this.cleanup();
    }

    protected void cleanup() {
        this.resourceProviders.clear();
        this.resources = null;
        this.configurator.clear();
        this.preOpen = null;
    }

    public void submit(Transactional.RunnableWithException work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.submit((Res res) -> work.run());
    }

    public <Res extends Resources> void submit(Transactional.ConsumerWithException<Res> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        this.resources.submit(work);
    }

    public <R> R submit(Callable<R> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        return (R)this.resources.submit((Res res) -> work.call());
    }

    public <Res extends Resources, R> R submit(Transactional.FunctionWithException<Res, R> work) {
        if (this.resources == null || !this.resources.isOpen()) {
            throw new IllegalStateException("Resources not opened");
        }
        return this.resources.submit(work);
    }

    public boolean isOpened() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isOpen();
    }

    public boolean isAborted() {
        if (this.resources == null) {
            return false;
        }
        return this.resources.isAborted();
    }
}

