/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.script.ScriptException;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.instance.InstanceFactory;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.logging.TimedLogger;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.resources.AlreadyBoundException;
import net.e6tech.elements.common.resources.Atom;
import net.e6tech.elements.common.resources.BeanLifecycle;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManagerListener;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.script.AbstractScriptShell;
import net.e6tech.elements.common.util.monitor.AllocationMonitor;
import org.apache.logging.log4j.ThreadContext;

public class ResourceManager
extends AbstractScriptShell
implements ResourcePool {
    private static Logger logger = Logger.getLogger();
    private String name;
    private Injector injector;
    private Module module = ModuleFactory.getInstance().create();
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private AllocationMonitor allocation = new AllocationMonitor();
    private Map<String, ResourceManager> resourceManagers;
    private Map<String, Atom> atoms = new LinkedHashMap<String, Atom>();
    private NotificationCenter notificationCenter = new NotificationCenter();
    private BeanLifecycle beanLifecycle = new BeanLifecycle();
    private PluginManager pluginManager = new PluginManager(this);
    private List<ResourceManagerListener> listeners = new LinkedList<ResourceManagerListener>();
    private Map<Class, ClassInjectionInfo> injections = new Hashtable<Class, ClassInjectionInfo>();

    public ResourceManager() {
        this(new Properties());
    }

    public ResourceManager(Provision provision) {
        this.initialize(this.pluginManager.getPluginClassLoader(), provision.getProperties());
        this._initialize(provision.getProperties());
        Object myProvision = this.loadProvision(provision.getClass());
        ((Provision)myProvision).load(provision.getResourceManager().getScripting().getVariables());
    }

    public ResourceManager(Properties properties) {
        this.initialize(this.pluginManager.getPluginClassLoader(), ResourceManager.updateProperties(properties));
        this._initialize(properties);
    }

    private void _initialize(Properties properties) {
        String logDir = properties.getProperty("logDir");
        if (logDir != null) {
            ThreadContext.put((String)"logDir", (String)logDir);
        } else {
            logDir = properties.getProperty("elements.common.logging.logDir");
            if (logDir != null) {
                ThreadContext.put((String)"logDir", (String)logDir);
            }
        }
        this.name = properties.getProperty("name");
        this.setModuleFactory(ModuleFactory.getInstance());
        Thread.currentThread().setContextClassLoader(this.pluginManager.getPluginClassLoader());
    }

    public void setModuleFactory(ModuleFactory factory) {
        this.module = factory.create();
        InstanceFactory instanceFactory = new InstanceFactory();
        this.module.bindInstance(ModuleFactory.class, factory);
        this.module.bindInstance(ResourceManager.class, this);
        this.module.bindInstance(NotificationCenter.class, this.notificationCenter);
        this.module.bindInstance(Interceptor.class, Interceptor.getInstance());
        this.module.bindInstance(InstanceFactory.class, instanceFactory);
        this.module.bindInstance(PluginManager.class, this.pluginManager);
        this.injector = this.module.build(new Module[0]);
        this.getScripting().put("notificationCenter", this.notificationCenter);
        this.getScripting().put("interceptor", Interceptor.getInstance());
        this.getScripting().put("instanceFactory", instanceFactory);
        this.getScripting().put("pluginManager", this.pluginManager);
    }

    public void addListener(ResourceManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ResourceManagerListener listener) {
        this.listeners.remove(listener);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    private static Properties updateProperties(Properties properties) {
        if (properties.getProperty("home") != null) {
            String home = properties.getProperty("home");
            String name = properties.getProperty("name");
            if (name == null) {
                try {
                    name = Paths.get(new File(home).getCanonicalPath(), new String[0]).getFileName().toString();
                    properties.setProperty("name", name);
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid home location " + home);
                }
            }
            properties.setProperty(name, home);
        }
        return properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            this.getScripting().remove(this.name);
        }
        this.name = name;
        this.getScripting().put(name, this.getProperties().getProperty("home"));
    }

    public Map<String, ResourceManager> getResourceManagers() {
        return this.resourceManagers;
    }

    public void setResourceManagers(Map<String, ResourceManager> resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    public ResourceManager getResourceManager(String name) {
        return this.resourceManagers.get(name);
    }

    public AllocationMonitor getAllocationMonitor() {
        return this.allocation;
    }

    public void onLaunched() {
        this.createLoggerContext();
        this.getScripting().onLaunched();
        super.onLoaded();
        this.beanLifecycle.clearBeanListeners();
    }

    public void createLoggerContext() {
        if (ThreadContext.get((String)"logDir") == null) {
            String logDir = null;
            if (System.getProperty("logDir") != null) {
                logDir = System.getProperty("logDir");
            } else if (System.getProperty("elements.common.logging.logDir") != null) {
                logDir = System.getProperty("elements.common.logging.logDir");
            } else {
                Properties properties = this.getProperties();
                logDir = properties.getProperty("logDir");
                if (logDir == null) {
                    logDir = properties.getProperty("elements.common.logging.logDir");
                }
            }
            if (logDir != null) {
                ThreadContext.put((String)"logDir", (String)logDir);
            }
        }
    }

    @Override
    protected void onLoaded() {
    }

    public <T> T getAtomResource(String atomName, String resourceName) {
        return (T)this.getAtoms().get(atomName).get(resourceName);
    }

    public Map<String, Atom> getAtoms() {
        return Collections.unmodifiableMap(this.atoms);
    }

    public Atom getAtom(String name) {
        return this.atoms.get(name);
    }

    public Atom removeAtom(String name) {
        return this.atoms.remove(name);
    }

    public Atom createAtom(String atomName, Consumer<Atom> consumer, Atom prototypeAtom, boolean prototype) {
        if (this.name != null && this.atoms.get(atomName) != null) {
            return this.atoms.get(atomName);
        }
        Atom atom = new Atom(this, prototypeAtom);
        atom.setPrototype(prototype);
        atom.setName(atomName);
        if (atomName == null) {
            logger.warn("Atom name is null", new Throwable());
        } else if (!prototype) {
            this.atoms.put(atomName, atom);
        }
        consumer.accept(atom);
        TimedLogger timed = new TimedLogger(0L);
        Atom comp = atom.build();
        timed.log("Atom " + atomName);
        return comp;
    }

    public <T extends Provision> T loadProvision(Class<? extends Provision> clazz) {
        Class<? extends Provision> cls = clazz;
        Provision provision = null;
        try {
            provision = cls.newInstance();
            this.inject(provision);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean alreadyBound = false;
        while (Provision.class.isAssignableFrom(cls)) {
            try {
                this.bind(cls, provision);
            }
            catch (AlreadyBoundException ex) {
                alreadyBound = true;
            }
            cls = cls.getSuperclass();
        }
        if (alreadyBound) {
            return (T)this.getInstance(Provision.class);
        }
        provision.load(this.getScripting().getVariables());
        this.getScripting().put("provision", provision);
        Provision p = provision;
        this.listeners.forEach(l -> l.provisionLoaded(p));
        return (T)provision;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    public boolean hasInstance(Class clazz) {
        if (Provision.class.isAssignableFrom(clazz)) {
            return true;
        }
        return this.injector.getInstance(clazz) != null;
    }

    public <T> T getInstance(Class<T> clazz) throws InstanceNotFoundException {
        T value = this.injector.getInstance(clazz);
        if (value == null) {
            if (Provision.class.isAssignableFrom(clazz)) {
                value = this.loadProvision(clazz);
            } else {
                throw new InstanceNotFoundException("No instance for class " + clazz.getName());
            }
        }
        return value;
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        T o = this.module.getBoundInstance(cls);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        this.module.bindInstance(cls, resource);
        this.injector = this.module.build(new Module[0]);
        Object instance = this.getInstance(cls);
        this.listeners.forEach(l -> l.bound(cls, instance));
        return instance;
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        this.module.bindInstance(cls, resource);
        this.injector = this.module.build(new Module[0]);
        Object instance = this.getInstance(cls);
        this.listeners.forEach(l -> l.bound(cls, instance));
        return instance;
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        Object instance = this.module.unbindInstance(cls);
        this.injector = this.module.build(new Module[0]);
        this.listeners.forEach(l -> l.unbound(cls, instance));
        return (T)instance;
    }

    public void tryBindClass(Class cls, Class service) {
        try {
            this.bindClass(cls, service);
        }
        catch (AlreadyBoundException alreadyBoundException) {
            // empty catch block
        }
    }

    @Override
    public void bindClass(Class cls, Class service) {
        Class c = this.module.getBoundClass(cls);
        if (c != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + c);
        }
        if (service != null) {
            this.module.bindClass(cls, service);
        } else {
            this.module.bindInstance(cls, null);
        }
        this.injector = this.module.build(new Module[0]);
        if (service != null) {
            this.listeners.forEach(l -> l.classBound(cls, service));
        } else {
            this.listeners.forEach(l -> l.classBound(cls, null));
        }
    }

    @Override
    public <T> T bindNamedInstance(Class<T> a, String name, T b) {
        T instance = this.module.getBoundNamedInstance(a, name);
        if (instance != null) {
            throw new AlreadyBoundException("Instance named " + name + " is already bound to " + instance);
        }
        this.module.bindNamedInstance(a, name, b);
        this.injector = this.module.build(new Module[0]);
        this.listeners.forEach(l -> l.namedInstanceBound(name, a, b));
        return instance;
    }

    @Override
    public <T> T rebindNamedInstance(Class<T> cls, String name, T resource) {
        Object instance = this.module.bindNamedInstance(cls, name, resource);
        this.injector = this.module.build(new Module[0]);
        this.listeners.forEach(l -> l.namedInstanceBound(name, cls, instance));
        return (T)instance;
    }

    @Override
    public <T> T inject(T obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof InjectionListener) {
            ((InjectionListener)obj).preInject(this);
        }
        this.injector.inject(obj);
        if (obj instanceof InjectionListener) {
            ((InjectionListener)obj).injected(this);
        }
        this.listeners.forEach(l -> l.injected(obj));
        return obj;
    }

    public BeanLifecycle getBeanLifecycle() {
        return this.beanLifecycle;
    }

    public <T> T registerBean(String name, Object instance) {
        Object obj = instance;
        if (instance instanceof Class) {
            obj = this.newInstance((Class)instance);
        } else {
            this.inject(obj);
        }
        return this.addBean(name, obj);
    }

    protected <T> T addBean(String name, Object instance) {
        if (this.getScripting().getVariables().get(name) != null) {
            throw logger.runtimeException("bean with name=" + name + " already registered");
        }
        try {
            Method method = instance.getClass().getMethod("setName", String.class);
            method.invoke(instance, name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getScripting().put(name, instance);
        this.listeners.forEach(l -> l.beanAdded(name, instance));
        return (T)instance;
    }

    public void unregisterBean(String name) {
        Object instance = this.getScripting().remove(name);
        this.listeners.forEach(l -> l.beanRemoved(name, instance));
    }

    @Override
    public <T> T getBean(String name) {
        return (T)this.getScripting().getVariables().get(name);
    }

    @Override
    public <T> T getBean(Class<T> cls) {
        Object value = null;
        Map<String, Object> variables = this.getScripting().getVariables();
        for (String key : variables.keySet()) {
            Object obj = variables.get(key);
            if (obj == null || !cls.isAssignableFrom(obj.getClass())) continue;
            if (value != null) {
                throw new RuntimeException("Multiple objects can be assigned to " + cls);
            }
            value = obj;
        }
        return (T)value;
    }

    public Map<String, Object> getBeans() {
        return this.getBeans(null);
    }

    public <T> Map<String, T> getBeans(Class<T> cls) {
        HashMap map = new HashMap();
        this.getScripting().getVariables().forEach((key, value) -> {
            if (cls == null || value != null && cls.isAssignableFrom(value.getClass())) {
                map.put(key, value);
            }
        });
        return Collections.unmodifiableMap(map);
    }

    public List listBeans() {
        Map<String, Object> variables = this.getScripting().getVariables();
        ArrayList list = new ArrayList(variables.size());
        variables.values().forEach(b -> list.add(b));
        return Collections.unmodifiableList(list);
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public synchronized void load(String str) throws ScriptException {
        this.load(str, true);
    }

    public synchronized void load(String str, boolean logInfo) throws ScriptException {
        long start = System.currentTimeMillis();
        super.load(str);
        if (logInfo) {
            int len = 0;
            LinkedList<String> atomString = new LinkedList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("    ");
            int count = this.atoms.size();
            int i = 1;
            for (String atomName : this.atoms.keySet()) {
                String msg;
                builder.append(atomName);
                if (i != count) {
                    builder.append(", ");
                }
                if (i % 5 == 0) {
                    msg = builder.toString();
                    if (len < msg.length()) {
                        len = msg.length();
                    }
                    atomString.add(builder.toString());
                    builder.setLength(0);
                    builder.append("    ");
                } else if (i == count) {
                    msg = builder.toString();
                    if (len < msg.length()) {
                        len = msg.length();
                    }
                    atomString.add(builder.toString());
                }
                ++i;
            }
            String message = "Done processing " + str;
            String message2 = "ResourceManager " + this.name + " loaded in " + (System.currentTimeMillis() - start) + "ms";
            if (message.length() > len) {
                len = message.length();
            }
            if (message2.length() > len) {
                len = message2.length();
            }
            char[] line = new char[len];
            Arrays.fill(line, '*');
            logger.info(new String(line));
            logger.info(message);
            logger.info(message2);
            logger.info("Loaded atoms:");
            for (String msg : atomString) {
                logger.info(msg);
            }
            logger.info(new String(line));
        }
    }

    public <Res extends Resources> Res open(Configurator configurator) {
        return (Res)this.open(configurator, resources -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Res extends Resources> Res open(Configurator configurator, Consumer<Res> preOpen) {
        Object resources = this.newResources();
        ((Resources)resources).configure(configurator);
        this.inject(resources);
        if (preOpen != null) {
            ((Resources)resources).setPreOpen(preOpen);
            preOpen.accept(resources);
        }
        LinkedList<ResourceProvider> list = new LinkedList<ResourceProvider>();
        List<ResourceProvider> list2 = this.resourceProviders;
        synchronized (list2) {
            list.addAll(this.resourceProviders);
        }
        LinkedList<ResourceProvider> openList = new LinkedList<ResourceProvider>();
        for (ResourceProvider p : list) {
            try {
                p.onOpen((Resources)resources);
                openList.add(p);
            }
            catch (NotAvailableException notAvailableException) {
            }
            catch (Throwable th) {
                ((Resources)resources).setExternalResourceProviders(openList);
                ((Resources)resources).onOpen();
                ((Resources)resources).abort();
                throw th;
            }
        }
        ((Resources)resources).setExternalResourceProviders(openList);
        ((Resources)resources).onOpen();
        return (Res)resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceProvider(ResourceProvider p) {
        this.inject(p);
        List<ResourceProvider> list = this.resourceProviders;
        synchronized (list) {
            this.resourceProviders.add(p);
        }
        this.listeners.forEach(l -> l.resourceProviderAdded(p));
    }

    public <T extends Resources> T newResources() {
        Provision provision = this.getInstance(Provision.class);
        Class<? extends Resources> clazz = provision.getResourcesClass();
        try {
            Constructor<? extends Resources> constructor = clazz.getDeclaredConstructor(ResourceManager.class);
            constructor.setAccessible(true);
            Resources resources = constructor.newInstance(this);
            return (T)this.inject(resources);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ShutdownNotification notification = new ShutdownNotification(this);
        this.getNotificationCenter().getNotificationListeners(notification).forEach(listener -> {
            logger.info("Shutting down " + listener.getDescription() + " ...");
            listener.onEvent(notification);
            logger.info(listener.getDescription() + " is down.");
        });
        ArrayList<ResourceProvider> reversed = new ArrayList<ResourceProvider>();
        List<ResourceProvider> list = this.resourceProviders;
        synchronized (list) {
            reversed.addAll(this.resourceProviders);
        }
        Collections.reverse(reversed);
        reversed.forEach(rp -> {
            logger.info("Shutting down " + rp.getDescription() + " ...");
            rp.onShutdown();
            logger.info(rp.getDescription() + " is down.");
        });
    }

    Map<Class, ClassInjectionInfo> getInjections() {
        return this.injections;
    }

    static class ClassInjectionInfo {
        private static final List<Field> emptyFields = Collections.unmodifiableList(new ArrayList());
        private List<Field> injectableFields = emptyFields;

        ClassInjectionInfo() {
        }

        void addInjectableField(Field field) {
            if (this.injectableFields == emptyFields) {
                this.injectableFields = new ArrayList<Field>();
            }
            this.injectableFields.add(field);
        }

        List<Field> getInjectableFields() {
            return this.injectableFields;
        }
    }
}

